/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.batch.runtimefilter;

import java.util.List;
import org.apache.flink.api.dag.Transformation;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.runtimefilter.RuntimeFilterCodeGenerator;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.fusion.OpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.generator.TwoInputOpFusionCodegenSpecGenerator;
import org.apache.flink.table.planner.plan.fusion.spec.RuntimeFilterFusionCodegenSpec;
import org.apache.flink.table.planner.plan.nodes.exec.ExecEdge;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeBase;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeConfig;
import org.apache.flink.table.planner.plan.nodes.exec.ExecNodeContext;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;
import org.apache.flink.table.planner.plan.nodes.exec.batch.BatchExecNode;
import org.apache.flink.table.planner.plan.nodes.exec.utils.ExecNodeUtil;
import org.apache.flink.table.runtime.operators.CodeGenOperatorFactory;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

public class BatchExecRuntimeFilter
extends ExecNodeBase<RowData>
implements BatchExecNode<RowData> {
    private final int[] probeIndices;

    public BatchExecRuntimeFilter(ReadableConfig tableConfig, List<InputProperty> inputProperties, LogicalType outputType, String description, int[] probeIndices) {
        super(ExecNodeContext.newNodeId(), ExecNodeContext.newContext(BatchExecRuntimeFilter.class), ExecNodeContext.newPersistedConfig(BatchExecRuntimeFilter.class, tableConfig), inputProperties, outputType, description);
        this.probeIndices = probeIndices;
    }

    @Override
    protected Transformation<RowData> translateToPlanInternal(PlannerBase planner, ExecNodeConfig config) {
        ExecEdge buildInputEdge = this.getInputEdges().get(0);
        ExecEdge probeInputEdge = this.getInputEdges().get(1);
        Transformation<?> buildTransform = buildInputEdge.translateToPlan(planner);
        Transformation<?> probeTransform = probeInputEdge.translateToPlan(planner);
        CodeGenOperatorFactory<RowData> operatorFactory = RuntimeFilterCodeGenerator.gen(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader()), (RowType)buildInputEdge.getOutputType(), (RowType)probeInputEdge.getOutputType(), this.probeIndices);
        return ExecNodeUtil.createTwoInputTransformation(buildTransform, probeTransform, this.createTransformationName(config), this.createTransformationDescription(config), operatorFactory, InternalTypeInfo.of((LogicalType)this.getOutputType()), probeTransform.getParallelism(), 0L, false);
    }

    @Override
    public boolean supportFusionCodegen() {
        return true;
    }

    @Override
    protected OpFusionCodegenSpecGenerator translateToFusionCodegenSpecInternal(PlannerBase planner, ExecNodeConfig config, CodeGeneratorContext parentCtx) {
        OpFusionCodegenSpecGenerator leftInput = this.getInputEdges().get(0).translateToFusionCodegenSpec(planner, parentCtx);
        OpFusionCodegenSpecGenerator rightInput = this.getInputEdges().get(1).translateToFusionCodegenSpec(planner, parentCtx);
        TwoInputOpFusionCodegenSpecGenerator runtimeFilterGenerator = new TwoInputOpFusionCodegenSpecGenerator(leftInput, rightInput, 0L, (RowType)this.getOutputType(), new RuntimeFilterFusionCodegenSpec(new CodeGeneratorContext(config, planner.getFlinkContext().getClassLoader(), parentCtx), this.probeIndices));
        leftInput.addOutput(1, runtimeFilterGenerator);
        rightInput.addOutput(2, runtimeFilterGenerator);
        return runtimeFilterGenerator;
    }
}

