/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.operations.converters;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.sql.parser.dql.SqlShowCall;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.utils.LikeType;
import org.apache.flink.table.operations.utils.ShowLikeOperator;
import org.apache.flink.table.planner.operations.converters.SqlNodeConverter;

public abstract class AbstractSqlShowConverter<T extends SqlShowCall>
implements SqlNodeConverter<T> {
    protected Operation convertShowOperation(T sqlShowCall, SqlNodeConverter.ConvertContext context) {
        ShowLikeOperator likeOp = this.getLikeOp((SqlShowCall)sqlShowCall);
        if (((SqlShowCall)sqlShowCall).getPreposition() == null) {
            CatalogManager catalogManager = context.getCatalogManager();
            String currentCatalogName = catalogManager.getCurrentCatalog();
            String currentDatabaseName = catalogManager.getCurrentDatabase();
            return this.getOperationWithoutPrep(sqlShowCall, currentCatalogName, currentDatabaseName, likeOp);
        }
        List<String> sqlIdentifierNameList = ((SqlShowCall)sqlShowCall).getSqlIdentifierNameList();
        if (sqlIdentifierNameList.size() > 2) {
            throw new ValidationException(String.format("%s from/in identifier [ %s ] format error, it should be [catalog_name.]database_name.", ((SqlShowCall)sqlShowCall).getOperator().getName(), String.join((CharSequence)".", sqlIdentifierNameList)));
        }
        CatalogManager catalogManager = context.getCatalogManager();
        String catalogName = sqlIdentifierNameList.size() == 1 ? catalogManager.getCurrentCatalog() : sqlIdentifierNameList.get(0);
        String databaseName = sqlIdentifierNameList.size() == 1 ? sqlIdentifierNameList.get(0) : sqlIdentifierNameList.get(1);
        return this.getOperation(sqlShowCall, catalogName, databaseName, ((SqlShowCall)sqlShowCall).getPreposition(), likeOp);
    }

    public ShowLikeOperator getLikeOp(SqlShowCall sqlShowCall) {
        return ShowLikeOperator.of((LikeType)LikeType.of((String)sqlShowCall.getLikeType(), (boolean)sqlShowCall.isNotLike()), (String)sqlShowCall.getLikeSqlPattern());
    }

    public abstract Operation getOperationWithoutPrep(T var1, @Nullable String var2, @Nullable String var3, @Nullable ShowLikeOperator var4);

    public abstract Operation getOperation(T var1, @Nullable String var2, @Nullable String var3, @Nullable String var4, @Nullable ShowLikeOperator var5);

    @Override
    public abstract Operation convertSqlNode(T var1, SqlNodeConverter.ConvertContext var2);
}

