/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen.sort;

import java.io.Serializable;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.data.DecimalData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.data.binary.BinaryRowData;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.Indenter$;
import org.apache.flink.table.planner.codegen.sort.ComparatorCodeGenerator$;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.runtime.generated.GeneratedNormalizedKeyComputer;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.generated.NormalizedKeyComputer;
import org.apache.flink.table.runtime.operators.sort.SortUtil;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimestampType;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=a\u0001B\u0017/\u0001uB\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003W\u0011!y\u0006A!b\u0001\n\u0003\u0001\u0007\u0002C7\u0001\u0005\u0003\u0005\u000b\u0011B1\t\u00119\u0004!\u0011!Q\u0001\n=DQa\u001d\u0001\u0005\u0002QDQa\u001d\u0001\u0005\u0002qD\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000fA\u0011\"a\u0004\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005e\u0001\u0001)A\u0005\u0003'A\u0011\"a\u0007\u0001\u0005\u0004%I!!\b\t\u0011\u0005\u0015\u0002\u0001)A\u0005\u0003?A\u0011\"a\n\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005m\u0002\u0001)A\u0005\u0003WA\u0011\"!\u0010\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005}\u0002\u0001)A\u0005\u0003WA\u0011\"!\u0011\u0001\u0005\u0004%I!!\u000b\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003WAA\"!\u0012\u0001!\u0003\u0005\u0019\u0011)A\u0005\u0003\u000fB\u0011\"a\u0018\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u0003\u000fA\u0011\"a\u0019\u0001\u0005\u0004%\t!!\u0002\t\u0011\u0005\u0015\u0004\u0001)A\u0005\u0003\u000fA\u0011\"a\u001a\u0001\u0005\u0004%\t!!\u001b\t\u0011\u0005-\u0004\u0001)A\u0005\u0003\u001bB\u0011\"!\u001c\u0001\u0005\u0004%\t!a\u001c\t\u0011\u0005E\u0004\u0001)A\u0005\u0003'Bq!a\u001d\u0001\t\u0003\t)\bC\u0004\u0002~\u0001!\t!a \t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA]\u0001\u0011\u0005\u00111\u0018\u0005\b\u0003\u0003\u0004A\u0011AAb\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013Dq!!4\u0001\t\u0003\ty\rC\u0004\u0002Z\u0002!\t!a7\t\u000f\u0005-\b\u0001\"\u0001\u0002n\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bbBA|\u0001\u0011\u0005\u0011\u0011 \u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u0017\u0011\u0011cU8si\u000e{G-Z$f]\u0016\u0014\u0018\r^8s\u0015\ty\u0003'\u0001\u0003t_J$(BA\u00193\u0003\u001d\u0019w\u000eZ3hK:T!a\r\u001b\u0002\u000fAd\u0017M\u001c8fe*\u0011QGN\u0001\u0006i\u0006\u0014G.\u001a\u0006\u0003oa\nQA\u001a7j].T!!\u000f\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0014aA8sO\u000e\u00011C\u0001\u0001?!\ty$)D\u0001A\u0015\u0005\t\u0015!B:dC2\f\u0017BA\"A\u0005\u0019\te.\u001f*fM\u0006YA/\u00192mK\u000e{gNZ5h!\t1\u0015*D\u0001H\u0015\tAe'A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0003\u0015\u001e\u0013aBU3bI\u0006\u0014G.Z\"p]\u001aLw-A\u0006dY\u0006\u001c8\u000fT8bI\u0016\u0014\bCA'S\u001b\u0005q%BA(Q\u0003\u0011a\u0017M\\4\u000b\u0003E\u000bAA[1wC&\u00111K\u0014\u0002\f\u00072\f7o\u001d'pC\u0012,'/A\u0003j]B,H/F\u0001W!\t9F,D\u0001Y\u0015\tI&,A\u0004m_\u001eL7-\u00197\u000b\u0005m#\u0014!\u0002;za\u0016\u001c\u0018BA/Y\u0005\u001d\u0011vn\u001e+za\u0016\fa!\u001b8qkR\u0004\u0013\u0001C:peR\u001c\u0006/Z2\u0016\u0003\u0005\u0004\"AY6\u000e\u0003\rT!\u0001Z3\u0002\tM\u0004Xm\u0019\u0006\u0003M\u001e\fA!\u001a=fG*\u0011\u0001.[\u0001\u0006]>$Wm\u001d\u0006\u0003UJ\nA\u0001\u001d7b]&\u0011An\u0019\u0002\t'>\u0014Ho\u00159fG\u0006I1o\u001c:u'B,7\rI\u0001\na\u0006\u0014XM\u001c;Dib\u0004\"\u0001]9\u000e\u0003AJ!A\u001d\u0019\u0003)\r{G-Z$f]\u0016\u0014\u0018\r^8s\u0007>tG/\u001a=u\u0003\u0019a\u0014N\\5u}Q1Qo\u001e=zun\u0004\"A\u001e\u0001\u000e\u00039BQ\u0001\u0012\u0005A\u0002\u0015CQa\u0013\u0005A\u00021CQ\u0001\u0016\u0005A\u0002YCQa\u0018\u0005A\u0002\u0005DQA\u001c\u0005A\u0002=$b!^?\u007f\u007f\u0006\u0005\u0001\"\u0002#\n\u0001\u0004)\u0005\"B&\n\u0001\u0004a\u0005\"\u0002+\n\u0001\u00041\u0006\"B0\n\u0001\u0004\t\u0017AF'B1~suJU'B\u0019&SV\tR0L\u000bf{F*\u0012(\u0016\u0005\u0005\u001d\u0001cA \u0002\n%\u0019\u00111\u0002!\u0003\u0007%sG/A\fN\u0003b{fj\u0014*N\u00032K%,\u0012#`\u0017\u0016Kv\fT#OA\u0005I1k\u0014*U?V#\u0016\nT\u000b\u0003\u0003'\u00012!TA\u000b\u0013\r\t9B\u0014\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015M{%\u000bV0V)&c\u0005%\u0001\u000bQ\u001fN\u001b\u0016J\u0011'F?\u000eCUKT&`'&SViU\u000b\u0003\u0003?\u0001RaPA\u0011\u0003\u000fI1!a\tA\u0005\u0015\t%O]1z\u0003U\u0001vjU*J\u00052+ul\u0011%V\u001d.{6+\u0013.F'\u0002\nQCQ-U\u000b~{\u0005+\u0012*B)>\u0013v,T!Q!&su)\u0006\u0002\u0002,AA\u0011QFA\u001c\u0003\u000f\t\u0019\"\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003%IW.\\;uC\ndWMC\u0002\u00026\u0001\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI$a\f\u0003\u00075\u000b\u0007/\u0001\fC3R+ul\u0014)F%\u0006#vJU0N\u0003B\u0003\u0016JT$!\u0003M\u0011\u0015\fV#`\t\u00163\u0015JT#`\u001b\u0006\u0003\u0006+\u0013(H\u0003Q\u0011\u0015\fV#`\t\u00163\u0015JT#`\u001b\u0006\u0003\u0006+\u0013(HA\u0005\u0011\")\u0017+F?\u000ec\u0015iU*`\u001b\u0006\u0003\u0006+\u0013(H\u0003M\u0011\u0015\fV#`\u00072\u000b5kU0N\u0003B\u0003\u0016JT$!\u0003\rAH%\r\t\f\u007f\u0005%\u0013qAA\u0004\u0003\u001b\n\u0019&C\u0002\u0002L\u0001\u0013a\u0001V;qY\u0016$\u0004cA \u0002P%\u0019\u0011\u0011\u000b!\u0003\u000f\t{w\u000e\\3b]B1\u0011QKA.\u0003\u000fi!!a\u0016\u000b\t\u0005e\u00131G\u0001\b[V$\u0018M\u00197f\u0013\u0011\ti&a\u0016\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM]\u0001\u001a]VdG.Q<be\u0016tuN]7bY&TX\rZ&fs2+g.\u0001\u000eok2d\u0017i^1sK:{'/\\1mSj,GmS3z\u0019\u0016t\u0007%\u0001\to_Jl\u0017\r\\5{K\u0012\\U-\u001f(v[\u0006\tbn\u001c:nC2L'0\u001a3LKftU/\u001c\u0011\u0002'%tg/\u001a:u\u001d>\u0014X.\u00197ju\u0016$7*Z=\u0016\u0005\u00055\u0013\u0001F5om\u0016\u0014HOT8s[\u0006d\u0017N_3e\u0017\u0016L\b%\u0001\u000bo_Jl\u0017\r\\5{K\u0012\\U-\u001f'f]\u001e$\bn]\u000b\u0003\u0003'\nQC\\8s[\u0006d\u0017N_3e\u0017\u0016LH*\u001a8hi\"\u001c\b%A\u000fhKR\\U-\u001f$vY2LH)\u001a;fe6Lg.Z:B]\u0012\u0014\u0015\u0010^3t+\t\t9\bE\u0004@\u0003s\ni%a\u0002\n\u0007\u0005m\u0004I\u0001\u0004UkBdWMM\u0001\u001eO\u0016tWM]1uK:{'/\\1mSj,GmS3z\u0007>l\u0007/\u001e;feR!\u0011\u0011QAI!\u0011\t\u0019)!$\u000e\u0005\u0005\u0015%\u0002BAD\u0003\u0013\u000b\u0011bZ3oKJ\fG/\u001a3\u000b\u0007\u0005-E'A\u0004sk:$\u0018.\\3\n\t\u0005=\u0015Q\u0011\u0002\u001f\u000f\u0016tWM]1uK\u0012tuN]7bY&TX\rZ&fs\u000e{W\u000e];uKJDq!a%!\u0001\u0004\t)*\u0001\u0003oC6,\u0007\u0003BAL\u0003KsA!!'\u0002\"B\u0019\u00111\u0014!\u000e\u0005\u0005u%bAAPy\u00051AH]8pizJ1!a)A\u0003\u0019\u0001&/\u001a3fM&!\u0011qCAT\u0015\r\t\u0019\u000bQ\u0001\u001aO\u0016tWM]1uKB+HOT8s[\u0006d\u0017N_3e\u0017\u0016L8\u000f\u0006\u0003\u0002.\u0006=\u0006CBA+\u00037\n)\nC\u0004\u00022\u0006\u0002\r!a\u0002\u0002\u00179,XnS3z\u0005f$Xm]\u0001\u0010G\u0006d7-\u001e7bi\u0016\u001c\u0005.\u001e8lgR!\u0011qDA\\\u0011\u001d\t\tL\ta\u0001\u0003\u000f\tQdZ3oKJ\fG/\u001a*fm\u0016\u00148/\u001a(pe6\fG.\u001b>fI.+\u0017p\u001d\u000b\u0005\u0003[\u000bi\fC\u0004\u0002@\u000e\u0002\r!a\b\u0002\r\rDWO\\6t\u0003u9WM\\3sCR,7i\\7qCJ,gj\u001c:nC2L'0\u001a3LKf\u001cH\u0003BAW\u0003\u000bDq!a0%\u0001\u0004\ty\"\u0001\u000ehK:,'/\u0019;f'^\f\u0007OT8s[\u0006d\u0017N_3e\u0017\u0016L8\u000f\u0006\u0003\u0002.\u0006-\u0007bBA`K\u0001\u0007\u0011qD\u0001\u0019O\u0016tWM]1uKJ+7m\u001c:e\u0007>l\u0007/\u0019:bi>\u0014H\u0003BAi\u0003/\u0004B!a!\u0002T&!\u0011Q[AC\u0005e9UM\\3sCR,GMU3d_J$7i\\7qCJ\fGo\u001c:\t\u000f\u0005Me\u00051\u0001\u0002\u0016\u00061q-\u001a;uKJ$b!!&\u0002^\u0006\u001d\bbBApO\u0001\u0007\u0011\u0011]\u0001\u0002iB\u0019q+a9\n\u0007\u0005\u0015\bLA\u0006M_\u001eL7-\u00197UsB,\u0007bBAuO\u0001\u0007\u0011qA\u0001\u0006S:$W\r_\u0001\u0017aJ,g-\u001b=QkRtuN]7bY&TX\rZ&fsR!\u0011QSAx\u0011\u001d\ty\u000e\u000ba\u0001\u0003C\fa\u0003\u001d:fM&Dx)\u001a;Ge>l')\u001b8bef\u0014vn\u001e\u000b\u0005\u0003+\u000b)\u0010C\u0004\u0002`&\u0002\r!!9\u0002\u001bM\fg-Z!eI2+gn\u001a;i)\u0019\t9!a?\u0002\u0000\"9\u0011Q \u0016A\u0002\u0005\u001d\u0011!A5\t\u000f\t\u0005!\u00061\u0001\u0002\b\u0005\t!.\u0001\u000btkB\u0004xN\u001d;O_Jl\u0017\r\\5{K\u0012\\U-\u001f\u000b\u0005\u0003\u001b\u00129\u0001C\u0004\u0002`.\u0002\r!!9\u0002%\u001d,GOT8s[\u0006d\u0017N_3LKfdUM\u001c\u000b\u0005\u0003\u000f\u0011i\u0001C\u0004\u0002`2\u0002\r!!9")
public class SortCodeGenerator {
    private final ReadableConfig tableConfig;
    private final ClassLoader classLoader;
    private final RowType input;
    private final SortSpec sortSpec;
    private final CodeGeneratorContext parentCtx;
    private final int MAX_NORMALIZED_KEY_LEN;
    private final String SORT_UTIL;
    private final int[] POSSIBLE_CHUNK_SIZES;
    private final Map<Object, String> BYTE_OPERATOR_MAPPING;
    private final Map<Object, String> BYTE_DEFINE_MAPPING;
    private final Map<Object, String> BYTE_CLASS_MAPPING;
    private final /* synthetic */ Tuple4 x$1;
    private final int nullAwareNormalizedKeyLen;
    private final int normalizedKeyNum;
    private final boolean invertNormalizedKey;
    private final ArrayBuffer<Object> normalizedKeyLengths;

    public RowType input() {
        return this.input;
    }

    public SortSpec sortSpec() {
        return this.sortSpec;
    }

    private int MAX_NORMALIZED_KEY_LEN() {
        return this.MAX_NORMALIZED_KEY_LEN;
    }

    private String SORT_UTIL() {
        return this.SORT_UTIL;
    }

    private int[] POSSIBLE_CHUNK_SIZES() {
        return this.POSSIBLE_CHUNK_SIZES;
    }

    private Map<Object, String> BYTE_OPERATOR_MAPPING() {
        return this.BYTE_OPERATOR_MAPPING;
    }

    private Map<Object, String> BYTE_DEFINE_MAPPING() {
        return this.BYTE_DEFINE_MAPPING;
    }

    private Map<Object, String> BYTE_CLASS_MAPPING() {
        return this.BYTE_CLASS_MAPPING;
    }

    public int nullAwareNormalizedKeyLen() {
        return this.nullAwareNormalizedKeyLen;
    }

    public int normalizedKeyNum() {
        return this.normalizedKeyNum;
    }

    public boolean invertNormalizedKey() {
        return this.invertNormalizedKey;
    }

    public ArrayBuffer<Object> normalizedKeyLengths() {
        return this.normalizedKeyLengths;
    }

    public Tuple2<Object, Object> getKeyFullyDeterminesAndBytes() {
        if (this.nullAwareNormalizedKeyLen() > 18) {
            return new Tuple2.mcZI.sp(false, Math.min(this.MAX_NORMALIZED_KEY_LEN(), 8 * this.normalizedKeyNum()));
        }
        return new Tuple2.mcZI.sp(this.normalizedKeyNum() == this.sortSpec().getFieldSize(), this.nullAwareNormalizedKeyLen());
    }

    public GeneratedNormalizedKeyComputer generateNormalizedKeyComputer(String name) {
        CodeGeneratorContext ctx = new CodeGeneratorContext(this.tableConfig, this.classLoader, this.parentCtx);
        String className = CodeGenUtils$.MODULE$.newName(ctx, name);
        Tuple2<Object, Object> tuple2 = this.getKeyFullyDeterminesAndBytes();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean keyFullyDetermines = tuple2._1$mcZ$sp();
        int numKeyBytes = tuple2._2$mcI$sp();
        Tuple2.mcZI.sp sp2 = new Tuple2.mcZI.sp(keyFullyDetermines, numKeyBytes);
        boolean keyFullyDetermines2 = sp2._1$mcZ$sp();
        int numKeyBytes2 = sp2._2$mcI$sp();
        ArrayBuffer<String> putKeys = this.generatePutNormalizedKeys(numKeyBytes2);
        int[] chunks = this.calculateChunks(numKeyBytes2);
        ArrayBuffer<String> reverseKeys = this.generateReverseNormalizedKeys(chunks);
        ArrayBuffer<String> compareKeys = this.generateCompareNormalizedKeys(chunks);
        ArrayBuffer<String> swapKeys = this.generateSwapNormalizedKeys(chunks);
        Class<NormalizedKeyComputer> baseClass = NormalizedKeyComputer.class;
        String code = new StringOps(Predef$.MODULE$.augmentString(Indenter$.MODULE$.toISC(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n      public class ", " implements ", " {\n\n        public ", "(Object[] references) {\n          // useless\n        }\n\n        @Override\n        public void putKey(", " record, ", " target, int offset) {\n          ", "\n          ", "\n        }\n\n        @Override\n        public int compareKey(", " segI, int offsetI, ", " segJ, int offsetJ) {\n          ", "\n        }\n\n        @Override\n        public void swapKey(", " segI, int offsetI, ", " segJ, int offsetJ) {\n          ", "\n        }\n\n        @Override\n        public int getNumKeyBytes() {\n          return ", ";\n        }\n\n        @Override\n        public boolean isKeyFullyDetermines() {\n          return ", ";\n        }\n\n        @Override\n        public boolean invertKey() {\n          return ", ";\n        }\n\n      }\n    "}))).j((Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className, baseClass.getCanonicalName(), className, CodeGenUtils$.MODULE$.ROW_DATA(), CodeGenUtils$.MODULE$.SEGMENT(), putKeys.mkString(), reverseKeys.mkString(), CodeGenUtils$.MODULE$.SEGMENT(), CodeGenUtils$.MODULE$.SEGMENT(), compareKeys.mkString(), CodeGenUtils$.MODULE$.SEGMENT(), CodeGenUtils$.MODULE$.SEGMENT(), swapKeys.mkString(), BoxesRunTime.boxToInteger((int)numKeyBytes2), BoxesRunTime.boxToBoolean((boolean)keyFullyDetermines2), BoxesRunTime.boxToBoolean((boolean)this.invertNormalizedKey())})))).stripMargin();
        return new GeneratedNormalizedKeyComputer(className, code, this.tableConfig);
    }

    public ArrayBuffer<String> generatePutNormalizedKeys(int numKeyBytes) {
        ArrayBuffer putKeys = new ArrayBuffer();
        int bytesLeft = numKeyBytes;
        int currentOffset = 0;
        for (int keyIndex = 0; bytesLeft > 0 && keyIndex < this.normalizedKeyNum(); ++keyIndex) {
            String string;
            int len = BoxesRunTime.unboxToInt((Object)this.normalizedKeyLengths().apply(keyIndex));
            SortSpec.SortFieldSpec fieldSpec = this.sortSpec().getFieldSpec(keyIndex);
            int index = fieldSpec.getFieldIndex();
            boolean nullIsMaxValue = fieldSpec.getIsAscendingOrder() == fieldSpec.getNullIsLast();
            len = bytesLeft >= len ? len : bytesLeft;
            LogicalType t = this.input().getTypeAt(fieldSpec.getFieldIndex());
            String prefix = this.prefixGetFromBinaryRow(t);
            LogicalType logicalType = t;
            if (this.getNormalizeKeyLen(t) != Integer.MAX_VALUE) {
                String get = this.getter(t, index);
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(148).append("\n             |target.put(offset+").append(currentOffset).append(", (byte) 1);\n             |").append(this.SORT_UTIL()).append(".put").append(this.prefixPutNormalizedKey(t)).append("NormalizedKey(\n             |  record.").append(get).append(", target, offset+").append(currentOffset + 1).append(", ").append(len - 1).append(");\n             |\n         ").toString())).stripMargin();
            } else {
                string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n             |").append(this.SORT_UTIL()).append(".put").append(this.prefixPutNormalizedKey(t)).append("NormalizedKey(\n             |  record.get").append(prefix).append("(").append(index).append("), target, offset+").append(currentOffset).append(", ").append(len).append(");\n             |").toString())).stripMargin();
            }
            String putCode = string;
            String nullCode = nullIsMaxValue ? new StringBuilder(37).append(this.SORT_UTIL()).append(".maxNormalizedKey(target, offset+").append(currentOffset).append(", ").append(len).append(");").toString() : new StringBuilder(37).append(this.SORT_UTIL()).append(".minNormalizedKey(target, offset+").append(currentOffset).append(", ").append(len).append(");").toString();
            String code = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(113).append("\n           |if (record.isNullAt(").append(index).append(")) {\n           | ").append(nullCode).append("\n           |} else {\n           | ").append(putCode).append("\n           |}\n           |").toString())).stripMargin();
            putKeys.$plus$eq((Object)code);
            bytesLeft -= len;
            currentOffset += len;
        }
        return putKeys;
    }

    public int[] calculateChunks(int numKeyBytes) {
        ArrayBuffer chunks = new ArrayBuffer();
        int i = 0;
        int remainBytes = numKeyBytes;
        while (remainBytes > 0) {
            int bytes = this.POSSIBLE_CHUNK_SIZES()[i];
            if (bytes <= remainBytes) {
                chunks.$plus$eq((Object)BoxesRunTime.boxToInteger((int)bytes));
                remainBytes -= bytes;
                continue;
            }
            ++i;
        }
        return (int[])chunks.toArray(ClassTag$.MODULE$.Int());
    }

    public ArrayBuffer<String> generateReverseNormalizedKeys(int[] chunks) {
        ArrayBuffer reverseKeys;
        block0: {
            reverseKeys = new ArrayBuffer();
            if (!BinaryRowData.LITTLE_ENDIAN) break block0;
            IntRef reverseOffset = IntRef.create((int)0);
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(chunks)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)chunk -> {
                BoxedUnit boxedUnit;
                String operator = (String)this.BYTE_OPERATOR_MAPPING().apply((Object)BoxesRunTime.boxToInteger((int)chunk));
                String className = (String)this.BYTE_CLASS_MAPPING().apply((Object)BoxesRunTime.boxToInteger((int)chunk));
                if (chunk != 1) {
                    String reverseKey = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(104).append("\n               |target.put").append(operator).append("(offset+").append(reverseOffset$1.elem).append(",\n               |  ").append(className).append(".reverseBytes(target.get").append(operator).append("(offset+").append(reverseOffset$1.elem).append(")));\n            ").toString())).stripMargin();
                    boxedUnit = reverseKeys.$plus$eq((Object)reverseKey);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                reverseOffset$1.elem += chunk;
            });
        }
        return reverseKeys;
    }

    public ArrayBuffer<String> generateCompareNormalizedKeys(int[] chunks) {
        ArrayBuffer compareKeys = new ArrayBuffer();
        IntRef compareOffset = IntRef.create((int)0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(chunks)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int chunk = chunks[i];
            String operator = (String)this.BYTE_OPERATOR_MAPPING().apply((Object)BoxesRunTime.boxToInteger((int)chunk));
            String define = (String)this.BYTE_DEFINE_MAPPING().apply((Object)BoxesRunTime.boxToInteger((int)chunk));
            String compareKey = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(228).append("\n           |").append(define).append(" l_").append(i).append("_1 = segI.get").append(operator).append("(offsetI+").append(compareOffset$1.elem).append(");\n           |").append(define).append(" l_").append(i).append("_2 = segJ.get").append(operator).append("(offsetJ+").append(compareOffset$1.elem).append(");\n           |if (l_").append(i).append("_1 != l_").append(i).append("_2) {\n           |  return ((l_").append(i).append("_1 < l_").append(i).append("_2) ^ (l_").append(i).append("_1 < 0) ^\n           |    (l_").append(i).append("_2 < 0) ? -1 : 1);\n           |}\n            ").toString())).stripMargin();
            compareKeys.$plus$eq((Object)compareKey);
            compareOffset$1.elem += chunk;
        });
        compareKeys.$plus$eq((Object)"return 0;");
        return compareKeys;
    }

    public ArrayBuffer<String> generateSwapNormalizedKeys(int[] chunks) {
        ArrayBuffer swapKeys = new ArrayBuffer();
        IntRef swapOffset = IntRef.create((int)0);
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(chunks)).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int chunk = chunks[i];
            String operator = (String)this.BYTE_OPERATOR_MAPPING().apply((Object)BoxesRunTime.boxToInteger((int)chunk));
            String define = (String)this.BYTE_DEFINE_MAPPING().apply((Object)BoxesRunTime.boxToInteger((int)chunk));
            String swapKey = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(143).append("\n           |").append(define).append(" temp").append(i).append(" = segI.get").append(operator).append("(offsetI+").append(swapOffset$1.elem).append(");\n           |segI.put").append(operator).append("(offsetI+").append(swapOffset$1.elem).append(", segJ.get").append(operator).append("(offsetJ+").append(swapOffset$1.elem).append("));\n           |segJ.put").append(operator).append("(offsetJ+").append(swapOffset$1.elem).append(", temp").append(i).append(");\n            ").toString())).stripMargin();
            swapKeys.$plus$eq((Object)swapKey);
            swapOffset$1.elem += chunk;
        });
        return swapKeys;
    }

    public GeneratedRecordComparator generateRecordComparator(String name) {
        return ComparatorCodeGenerator$.MODULE$.gen(this.tableConfig, this.classLoader, name, this.input(), this.sortSpec(), this.parentCtx);
    }

    public String getter(LogicalType t, int index) {
        String prefix = this.prefixGetFromBinaryRow(t);
        LogicalType logicalType = t;
        if (logicalType instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)logicalType;
            return new StringBuilder(9).append("get").append(prefix).append("(").append(index).append(", ").append(decimalType.getPrecision()).append(", ").append(decimalType.getScale()).append(")").toString();
        }
        if (logicalType instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)logicalType;
            return new StringBuilder(7).append("get").append(prefix).append("(").append(index).append(", ").append(timestampType.getPrecision()).append(")").toString();
        }
        return new StringBuilder(5).append("get").append(prefix).append("(").append(index).append(")").toString();
    }

    public String prefixPutNormalizedKey(LogicalType t) {
        return this.prefixGetFromBinaryRow(t);
    }

    public String prefixGetFromBinaryRow(LogicalType t) {
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            return "Int";
        }
        if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            return "Long";
        }
        if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            return "Short";
        }
        if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            return "Byte";
        }
        if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            return "Float";
        }
        if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            return "Double";
        }
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            return "Boolean";
        }
        if (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.CHAR.equals(logicalTypeRoot)) {
            return "String";
        }
        if (LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot)) {
            return "Binary";
        }
        if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
            return "Decimal";
        }
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            return "Int";
        }
        if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return "Int";
        }
        if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return "Timestamp";
        }
        if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            return "Int";
        }
        if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            return "Long";
        }
        return null;
    }

    public int safeAddLength(int i, int j) {
        int sum = i + j;
        if (sum < i || sum < j) {
            return Integer.MAX_VALUE;
        }
        return sum;
    }

    public boolean supportNormalizedKey(LogicalType t) {
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (PlannerTypeUtils.isPrimitive((LogicalType)t)) {
            return true;
        }
        if (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.CHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.DATE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)))))) {
            return true;
        }
        if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return TimestampData.isCompact((int)((TimestampType)t).getPrecision());
        }
        if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
            return DecimalData.isCompact((int)((DecimalType)t).getPrecision());
        }
        return false;
    }

    public int getNormalizeKeyLen(LogicalType t) {
        LogicalTypeRoot logicalTypeRoot = t.getTypeRoot();
        if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
            return 1;
        }
        if (LogicalTypeRoot.TINYINT.equals(logicalTypeRoot)) {
            return 1;
        }
        if (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot)) {
            return 2;
        }
        if (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot)) {
            return 4;
        }
        if (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot)) {
            return 4;
        }
        if (LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)) {
            return 8;
        }
        if (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot)) {
            return 8;
        }
        if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) && TimestampData.isCompact((int)((TimestampType)t).getPrecision())) {
            return 8;
        }
        if (LogicalTypeRoot.INTERVAL_YEAR_MONTH.equals(logicalTypeRoot)) {
            return 4;
        }
        if (LogicalTypeRoot.INTERVAL_DAY_TIME.equals(logicalTypeRoot)) {
            return 8;
        }
        if (LogicalTypeRoot.DATE.equals(logicalTypeRoot)) {
            return 4;
        }
        if (LogicalTypeRoot.TIME_WITHOUT_TIME_ZONE.equals(logicalTypeRoot)) {
            return 4;
        }
        if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot) && DecimalData.isCompact((int)((DecimalType)t).getPrecision())) {
            return 8;
        }
        if (LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.CHAR.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.BINARY.equals(logicalTypeRoot)))) {
            return Integer.MAX_VALUE;
        }
        throw new MatchError((Object)logicalTypeRoot);
    }

    public SortCodeGenerator(ReadableConfig tableConfig, ClassLoader classLoader, RowType input, SortSpec sortSpec, CodeGeneratorContext parentCtx) {
        this.tableConfig = tableConfig;
        this.classLoader = classLoader;
        this.input = input;
        this.sortSpec = sortSpec;
        this.parentCtx = parentCtx;
        this.MAX_NORMALIZED_KEY_LEN = 16;
        this.SORT_UTIL = SortUtil.class.getCanonicalName();
        this.POSSIBLE_CHUNK_SIZES = new int[]{8, 4, 2, 1};
        this.BYTE_OPERATOR_MAPPING = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)"Long"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"Int"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"Short"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"")}));
        this.BYTE_DEFINE_MAPPING = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)"long"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"int"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"short"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"byte")}));
        this.BYTE_CLASS_MAPPING = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)"Long"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)"Integer"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)"Short"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)"Byte")}));
        int keyLen = 0;
        int keyNum = 0;
        boolean inverted = false;
        ArrayBuffer keyLengths = new ArrayBuffer();
        boolean bl = false;
        for (int i = 0; i < sortSpec.getFieldSize() && !bl; ++i) {
            SortSpec.SortFieldSpec fieldSpec = sortSpec.getFieldSpec(i);
            LogicalType t = input.getTypeAt(fieldSpec.getFieldIndex());
            if (this.supportNormalizedKey(t)) {
                boolean invert;
                boolean bl2 = invert = !fieldSpec.getIsAscendingOrder();
                if (i == 0) {
                    inverted = invert;
                }
                if (invert != inverted) {
                    bl = true;
                    continue;
                }
                ++keyNum;
                int len = this.safeAddLength(this.getNormalizeKeyLen(t), 1);
                if (len < 0) {
                    throw new RuntimeException(new StringBuilder(53).append(t).append(" specifies an invalid length for the normalized key: ").append(len).toString());
                }
                keyLengths.$plus$eq((Object)BoxesRunTime.boxToInteger((int)len));
                keyLen = this.safeAddLength(keyLen, len);
                if (keyLen != Integer.MAX_VALUE) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        Tuple4 tuple4 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)keyLen), (Object)BoxesRunTime.boxToInteger((int)keyNum), (Object)BoxesRunTime.boxToBoolean((boolean)inverted), (Object)keyLengths);
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        int nullAwareNormalizedKeyLen = BoxesRunTime.unboxToInt((Object)tuple4._1());
        int normalizedKeyNum = BoxesRunTime.unboxToInt((Object)tuple4._2());
        boolean invertNormalizedKey = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
        ArrayBuffer normalizedKeyLengths = (ArrayBuffer)tuple4._4();
        this.x$1 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)nullAwareNormalizedKeyLen), (Object)BoxesRunTime.boxToInteger((int)normalizedKeyNum), (Object)BoxesRunTime.boxToBoolean((boolean)invertNormalizedKey), (Object)normalizedKeyLengths);
        this.nullAwareNormalizedKeyLen = BoxesRunTime.unboxToInt((Object)this.x$1._1());
        this.normalizedKeyNum = BoxesRunTime.unboxToInt((Object)this.x$1._2());
        this.invertNormalizedKey = BoxesRunTime.unboxToBoolean((Object)this.x$1._3());
        this.normalizedKeyLengths = (ArrayBuffer)this.x$1._4();
    }

    public SortCodeGenerator(ReadableConfig tableConfig, ClassLoader classLoader, RowType input, SortSpec sortSpec) {
        this(tableConfig, classLoader, input, sortSpec, null);
    }
}

