/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.sql.parser.dql;

import org.apache.calcite.sql.SqlCharStringLiteral;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.flink.sql.parser.dql.SqlShowCall;
import org.apache.flink.sql.parser.impl.ParseException;

public class SqlShowDatabases
extends SqlShowCall {
    public static final SqlSpecialOperator OPERATOR = new SqlSpecialOperator("SHOW DATABASES", SqlKind.OTHER);

    public SqlShowDatabases(SqlParserPos pos, String preposition, SqlIdentifier catalogName, String likeType, SqlCharStringLiteral likeLiteral, boolean notLike) throws ParseException {
        super(pos, preposition, catalogName, likeType, likeLiteral, notLike);
        if (catalogName != null && catalogName.names.size() > 1) {
            throw new ParseException(String.format("Show databases from/in identifier [ %s ] format error, catalog must be a single part identifier.", String.join((CharSequence)".", catalogName.names)));
        }
    }

    public String getCatalogName() {
        return this.getSqlIdentifierNameList().isEmpty() ? null : this.getSqlIdentifierNameList().get(0);
    }

    @Override
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    String getOperationName() {
        return "SHOW DATABASES";
    }
}

