/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.linq4j.Nullness;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.SqlTypeConstructorFunction;
import org.apache.calcite.sql.SqlUnresolvedFunction;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeInference;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;
import org.apache.calcite.sql.validate.implicit.TypeCoercion;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.flink.calcite.shaded.org.checkerframework.checker.nullness.qual.Nullable;
import org.apache.flink.calcite.shaded.org.checkerframework.dataflow.qual.Pure;

public class SqlFunction
extends SqlOperator {
    private final SqlFunctionCategory category;
    private final @Nullable SqlIdentifier sqlIdentifier;

    public SqlFunction(String name, SqlKind kind, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        this(name, null, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
        assert (category != SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR || returnTypeInference != null);
    }

    public SqlFunction(SqlIdentifier sqlIdentifier, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, @Nullable List<RelDataType> paramTypes, SqlFunctionCategory funcType) {
        this(Util.last(sqlIdentifier.names), sqlIdentifier, SqlKind.OTHER_FUNCTION, returnTypeInference, operandTypeInference, operandTypeChecker, paramTypes, funcType);
    }

    @Deprecated
    protected SqlFunction(String name, @Nullable SqlIdentifier sqlIdentifier, SqlKind kind, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, @Nullable List<RelDataType> paramTypes, SqlFunctionCategory category) {
        this(name, sqlIdentifier, kind, returnTypeInference, operandTypeInference, operandTypeChecker, category);
    }

    protected SqlFunction(String name, @Nullable SqlIdentifier sqlIdentifier, SqlKind kind, @Nullable SqlReturnTypeInference returnTypeInference, @Nullable SqlOperandTypeInference operandTypeInference, @Nullable SqlOperandTypeChecker operandTypeChecker, SqlFunctionCategory category) {
        super(name, kind, 100, 100, returnTypeInference, operandTypeInference, operandTypeChecker);
        this.sqlIdentifier = sqlIdentifier;
        this.category = Objects.requireNonNull(category, "category");
    }

    @Override
    public SqlSyntax getSyntax() {
        return SqlSyntax.FUNCTION;
    }

    public @Nullable SqlIdentifier getSqlIdentifier() {
        return this.sqlIdentifier;
    }

    @Override
    public SqlIdentifier getNameAsId() {
        if (this.sqlIdentifier != null) {
            return this.sqlIdentifier;
        }
        return super.getNameAsId();
    }

    @Deprecated
    public @Nullable List<RelDataType> getParamTypes() {
        return null;
    }

    @Deprecated
    public List<String> getParamNames() {
        return Functions.generate(Nullness.castNonNull(this.getParamTypes()).size(), i -> "arg" + i);
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        this.getSyntax().unparse(writer, this, call, leftPrec, rightPrec);
    }

    public SqlFunctionCategory getFunctionType() {
        return this.category;
    }

    @Pure
    public boolean isQuantifierAllowed() {
        return false;
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        super.validateCall(call, validator, scope, operandScope);
        this.validateQuantifier(validator, call);
    }

    protected void validateQuantifier(SqlValidator validator, SqlCall call) {
        SqlLiteral functionQuantifier = call.getFunctionQuantifier();
        if (null != functionQuantifier && !this.isQuantifierAllowed()) {
            throw validator.newValidationError(functionQuantifier, Static.RESOURCE.functionQuantifierNotAllowed(call.getOperator().getName()));
        }
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        return this.deriveType(validator, scope, call, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call, boolean convertRowArgToColumnList) {
        SqlValidatorScope operandScope = scope.getOperandScope(call);
        validator.pushFunctionCall();
        List<String> argNames = this.constructArgNameList(call);
        List<SqlNode> args = this.constructOperandList(validator, call, argNames);
        List<RelDataType> argTypes = this.constructArgTypeList(validator, scope, call, args, convertRowArgToColumnList);
        SqlFunction function = (SqlFunction)SqlUtil.lookupRoutine(validator.getOperatorTable(), validator.getTypeFactory(), this.getNameAsId(), argTypes, argNames, this.getFunctionType(), SqlSyntax.FUNCTION, this.getKind(), validator.getCatalogReader().nameMatcher(), false);
        try {
            TypeCoercion typeCoercion;
            if (convertRowArgToColumnList && SqlFunction.containsRowArg(args)) {
                if (function == null && SqlUtil.matchRoutinesByParameterCount(validator.getOperatorTable(), this.getNameAsId(), argTypes, this.getFunctionType(), validator.getCatalogReader().nameMatcher())) {
                    for (SqlNode operand : args) {
                        if (operand.getKind() != SqlKind.ROW) continue;
                        validator.removeValidatedNodeType(operand);
                    }
                    RelDataType relDataType = this.deriveType(validator, scope, call, false);
                    return relDataType;
                }
                if (function != null) {
                    validator.validateColumnListParams(function, argTypes, args);
                }
            }
            if (this.getFunctionType() == SqlFunctionCategory.USER_DEFINED_CONSTRUCTOR) {
                RelDataType relDataType = validator.deriveConstructorType(scope, call, this, function, argTypes);
                return relDataType;
            }
            if (!(function != null || validator.config().typeCoercionEnabled() && (function = (SqlFunction)SqlUtil.lookupRoutine(validator.getOperatorTable(), validator.getTypeFactory(), this.getNameAsId(), argTypes, argNames, this.getFunctionType(), SqlSyntax.FUNCTION, this.getKind(), validator.getCatalogReader().nameMatcher(), true)) != null && (typeCoercion = validator.getTypeCoercion()).userDefinedFunctionCoercion(scope, call, function))) {
                SqlFunction x = (SqlFunction)call.getOperator();
                SqlIdentifier identifier = Util.first(x.getSqlIdentifier(), new SqlIdentifier(x.getName(), SqlParserPos.ZERO));
                RelDataType type = validator.getCatalogReader().getNamedType(identifier);
                if (type != null) {
                    function = new SqlTypeConstructorFunction(identifier, type);
                } else if (function == null && validator.config().lenientOperatorLookup()) {
                    function = new SqlUnresolvedFunction(identifier, null, null, OperandTypes.VARIADIC, null, x.getFunctionType());
                } else {
                    throw validator.handleUnresolvedFunction(call, this, argTypes, argNames);
                }
            }
            ((SqlBasicCall)call).setOperator(function);
            RelDataType relDataType = function.validateOperands(validator, operandScope, call);
            return relDataType;
        }
        finally {
            validator.popFunctionCall();
        }
    }

    private static boolean containsRowArg(List<SqlNode> args) {
        for (SqlNode operand : args) {
            if (operand.getKind() != SqlKind.ROW) continue;
            return true;
        }
        return false;
    }
}

