/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.table.SavepointDataStreamScanProvider;
import org.apache.flink.state.table.StateValueColumnConfiguration;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.types.logical.RowType;

public class SavepointDynamicTableSource
implements ScanTableSource {
    @Nullable
    private final String stateBackendType;
    private final String statePath;
    private final OperatorIdentifier operatorIdentifier;
    private final TypeInformation keyTypeInfo;
    private final Tuple2<Integer, List<StateValueColumnConfiguration>> keyValueProjections;
    private final RowType rowType;

    public SavepointDynamicTableSource(@Nullable String stateBackendType, String statePath, OperatorIdentifier operatorIdentifier, TypeInformation keyTypeInfo, Tuple2<Integer, List<StateValueColumnConfiguration>> keyValueProjections, RowType rowType) {
        this.stateBackendType = stateBackendType;
        this.statePath = statePath;
        this.operatorIdentifier = operatorIdentifier;
        this.keyValueProjections = keyValueProjections;
        this.keyTypeInfo = keyTypeInfo;
        this.rowType = rowType;
    }

    public DynamicTableSource copy() {
        return new SavepointDynamicTableSource(this.stateBackendType, this.statePath, this.operatorIdentifier, this.keyTypeInfo, this.keyValueProjections, this.rowType);
    }

    public String asSummaryString() {
        return "Savepoint Table Source";
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext scanContext) {
        return new SavepointDataStreamScanProvider(this.stateBackendType, this.statePath, this.operatorIdentifier, this.keyTypeInfo, this.keyValueProjections, this.rowType);
    }
}

