/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.table;

import java.util.Optional;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.table.SavepointConnectorOptions;

@PublicEvolving
public class SavepointConnectorOptionsUtil {
    public static OperatorIdentifier getOperatorIdentifier(ReadableConfig options) {
        Optional operatorUid = options.getOptional(SavepointConnectorOptions.OPERATOR_UID);
        Optional operatorUidHash = options.getOptional(SavepointConnectorOptions.OPERATOR_UID_HASH);
        if (operatorUid.isPresent() == operatorUidHash.isPresent()) {
            throw new IllegalArgumentException("Either operator uid or operator uid hash must be specified.");
        }
        return operatorUid.map(OperatorIdentifier::forUid).orElseGet(() -> OperatorIdentifier.forUidHash((String)operatorUidHash.get()));
    }

    private SavepointConnectorOptionsUtil() {
    }
}

