/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.state.api.output;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.runtime.checkpoint.OperatorState;
import org.apache.flink.state.api.OperatorIdentifier;
import org.apache.flink.state.api.output.TaggedOperatorSubtaskState;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

@Internal
public class OperatorSubtaskStateReducer
extends RichGroupReduceFunction<TaggedOperatorSubtaskState, OperatorState> {
    private static final long serialVersionUID = 1L;
    private final OperatorIdentifier operatorIdentifier;
    private final int maxParallelism;

    public OperatorSubtaskStateReducer(OperatorIdentifier operatorIdentifier, int maxParallelism) {
        Preconditions.checkNotNull((Object)operatorIdentifier, (String)"Operator identifier must not be null.");
        Preconditions.checkState((maxParallelism > 1 ? 1 : 0) != 0);
        this.operatorIdentifier = operatorIdentifier;
        this.maxParallelism = maxParallelism;
    }

    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
    }

    public void reduce(Iterable<TaggedOperatorSubtaskState> values, Collector<OperatorState> out) {
        List subtasks = StreamSupport.stream(values.spliterator(), false).collect(Collectors.toList());
        OperatorState operatorState = new OperatorState("ReducedOperatorState", (String)this.operatorIdentifier.getUid().orElse(null), this.operatorIdentifier.getOperatorId(), subtasks.size(), this.maxParallelism);
        for (TaggedOperatorSubtaskState value : subtasks) {
            operatorState.putState(value.index, value.state);
        }
        out.collect((Object)operatorState);
    }
}

