/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup.keyordered;

import java.util.Deque;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.operators.async.queue.StreamElementQueueEntry;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.AecRecord;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.Epoch;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.EpochManager;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.KeyAccountingUnit;
import org.apache.flink.table.runtime.operators.join.lookup.keyordered.RecordsBuffer;
import org.apache.flink.util.function.BiFunctionWithException;
import org.apache.flink.util.function.ThrowingConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableAsyncExecutionController<IN, OUT, KEY> {
    private static final Logger LOG = LoggerFactory.getLogger(TableAsyncExecutionController.class);
    private final ThrowingConsumer<AecRecord<IN, OUT>, Exception> asyncInvoke;
    private final ThrowingConsumer<Watermark, Exception> emitWatermark;
    private final Consumer<StreamElementQueueEntry<OUT>> emitResult;
    private final Function<StreamElementQueueEntry<OUT>, Integer> inferDrivenInputIndex;
    private final BiFunctionWithException<StreamRecord<IN>, Integer, KEY, Exception> inferBlockingKey;
    private final KeyAccountingUnit<KEY> keyAccountingUnit;
    private final RecordsBuffer<AecRecord<IN, OUT>, KEY> recordsBuffer;
    private final EpochManager<OUT> epochManager;
    private final AecRecord<IN, OUT> reusedRecord;

    public TableAsyncExecutionController(ThrowingConsumer<AecRecord<IN, OUT>, Exception> asyncInvoke, ThrowingConsumer<Watermark, Exception> emitWatermark, Consumer<StreamElementQueueEntry<OUT>> emitResult, Function<StreamElementQueueEntry<OUT>, Integer> inferDrivenInputIndex, BiFunctionWithException<StreamRecord<IN>, Integer, KEY, Exception> inferBlockingKey) {
        this.asyncInvoke = asyncInvoke;
        this.emitWatermark = emitWatermark;
        this.emitResult = emitResult;
        this.inferDrivenInputIndex = inferDrivenInputIndex;
        this.inferBlockingKey = inferBlockingKey;
        this.keyAccountingUnit = new KeyAccountingUnit();
        this.recordsBuffer = new RecordsBuffer();
        this.epochManager = new EpochManager();
        this.reusedRecord = new AecRecord();
    }

    public void registerMetrics(MetricGroup metricGroup) {
        metricGroup.gauge("aec_inflight_size", this.recordsBuffer::getActiveSize);
        metricGroup.gauge("aec_blocking_size", this.recordsBuffer::getBlockingSize);
        metricGroup.gauge("aec_finish_size", this.recordsBuffer::getFinishSize);
    }

    public void completeRecord(StreamElementQueueEntry<OUT> resultFuture, AecRecord<IN, OUT> aecRecord) throws Exception {
        KEY key = this.getKey(aecRecord);
        this.recordsBuffer.finish(key, aecRecord);
        this.keyAccountingUnit.release(aecRecord.getRecord(), key);
        Epoch epoch = aecRecord.getEpoch();
        epoch.collect(resultFuture);
        epoch.setOutput(element -> {
            this.emitResult.accept((StreamElementQueueEntry<OUT>)element);
            this.outputRecord((StreamRecord)element.getInputElement(), epoch, this.inferDrivenInputIndex.apply((StreamElementQueueEntry<OUT>)element));
        });
        this.epochManager.completeOneRecord(epoch);
        this.trigger(key);
    }

    public void recovery(StreamRecord<IN> record, Watermark watermark, int inputIndex) throws Exception {
        Optional<Epoch<OUT>> epoch = this.epochManager.getProperEpoch(watermark);
        if (epoch.isPresent()) {
            this.submitRecord(record, epoch.get(), inputIndex);
        } else {
            this.submitWatermark(watermark);
            this.submitRecord(record, null, inputIndex);
        }
    }

    public void submitRecord(StreamRecord<IN> record, @Nullable Epoch<OUT> epoch, int inputIndex) throws Exception {
        Epoch<OUT> currentEpoch;
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("size in records buffer:  %s", this.recordsBuffer.sizeToString()));
        }
        if (epoch != null) {
            currentEpoch = epoch;
            epoch.incrementCount();
        } else {
            currentEpoch = this.epochManager.onRecord();
        }
        AecRecord<IN, OUT> aecRecord = new AecRecord<IN, OUT>(record, currentEpoch, inputIndex);
        KEY key = this.getKey(record, inputIndex);
        this.recordsBuffer.enqueueRecord(key, aecRecord);
        this.trigger(key);
    }

    public void submitWatermark(Watermark watermark) {
        this.epochManager.onNonRecord(watermark, () -> {
            try {
                this.emitWatermark.accept((Object)watermark);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to emit watermark", e);
            }
        });
    }

    public Map<KEY, Deque<AecRecord<IN, OUT>>> pendingElements() {
        return this.recordsBuffer.pendingElements();
    }

    public void outputRecord(StreamRecord<IN> record, Epoch<OUT> epoch, int inputIndex) {
        this.reusedRecord.reset(record, epoch, inputIndex);
        this.recordsBuffer.output(this.getKey(record, inputIndex), this.reusedRecord);
    }

    public void close() {
        this.epochManager.close();
        this.recordsBuffer.close();
    }

    @VisibleForTesting
    public Epoch<OUT> getActiveEpoch() {
        return this.epochManager.getActiveEpoch();
    }

    @VisibleForTesting
    public EpochManager<OUT> getEpochManager() {
        return this.epochManager;
    }

    @VisibleForTesting
    public int getBlockingSize() {
        return this.recordsBuffer.getBlockingSize();
    }

    @VisibleForTesting
    public int getFinishSize() {
        return this.recordsBuffer.getFinishSize();
    }

    @VisibleForTesting
    public int getInFlightSize() {
        return this.recordsBuffer.getActiveSize();
    }

    @VisibleForTesting
    public RecordsBuffer<AecRecord<IN, OUT>, KEY> getRecordsBuffer() {
        return this.recordsBuffer;
    }

    @VisibleForTesting
    public ThrowingConsumer<AecRecord<IN, OUT>, Exception> getAsyncInvoke() {
        return this.asyncInvoke;
    }

    @VisibleForTesting
    public ThrowingConsumer<Watermark, Exception> getEmitWatermark() {
        return this.emitWatermark;
    }

    @VisibleForTesting
    public Consumer<StreamElementQueueEntry<OUT>> getEmitResult() {
        return this.emitResult;
    }

    @VisibleForTesting
    public Function<StreamElementQueueEntry<OUT>, Integer> getInferDrivenInputIndex() {
        return this.inferDrivenInputIndex;
    }

    @VisibleForTesting
    public BiFunctionWithException<StreamRecord<IN>, Integer, KEY, Exception> getInferBlockingKey() {
        return this.inferBlockingKey;
    }

    private void trigger(KEY key) {
        Optional<AecRecord<IN, OUT>> element;
        if (this.ifOccupy(key) && (element = this.recordsBuffer.pop(key)).isPresent() && this.tryOccupyKey(element.get().getRecord(), key)) {
            try {
                this.asyncInvoke.accept(element.get());
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to async invoke the record", e);
            }
        }
    }

    private boolean tryOccupyKey(StreamRecord<IN> record, KEY key) {
        return this.keyAccountingUnit.occupy(record, key);
    }

    private boolean ifOccupy(KEY key) {
        return this.keyAccountingUnit.ifOccupy(key);
    }

    private KEY getKey(StreamRecord<IN> record, int inputIndex) {
        try {
            return (KEY)this.inferBlockingKey.apply(record, (Object)inputIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to retrieve key from record " + String.valueOf(record), e);
        }
    }

    private KEY getKey(AecRecord<IN, OUT> aecRecord) {
        StreamRecord<IN> record = aecRecord.getRecord();
        return this.getKey(record, aecRecord.getInputIndex());
    }
}

