/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.dynamodbv2.model.CsvOptions;
import java.util.List;

@SdkInternalApi
public class CsvOptionsMarshaller {
    private static final MarshallingInfo<String> DELIMITER_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Delimiter").build();
    private static final MarshallingInfo<List> HEADERLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("HeaderList").build();
    private static final CsvOptionsMarshaller instance = new CsvOptionsMarshaller();

    public static CsvOptionsMarshaller getInstance() {
        return instance;
    }

    public void marshall(CsvOptions csvOptions, ProtocolMarshaller protocolMarshaller) {
        if (csvOptions == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(csvOptions.getDelimiter(), DELIMITER_BINDING);
            protocolMarshaller.marshall(csvOptions.getHeaderList(), HEADERLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

