/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.file.sink.compactor.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.flink.annotation.Internal;
import org.apache.flink.connector.file.sink.FileSinkCommittable;
import org.apache.flink.connector.file.sink.compactor.FileCompactor;
import org.apache.flink.connector.file.sink.compactor.OutputStreamBasedFileCompactor;
import org.apache.flink.connector.file.sink.compactor.RecordWiseFileCompactor;
import org.apache.flink.connector.file.sink.compactor.operator.CompactorRequest;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.util.Hardware;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.CompactingFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.InProgressFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputStreamBasedCompactingFileWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.RecordWiseCompactingFileWriter;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.concurrent.ExecutorThreadFactory;

@Internal
public class CompactService {
    private static final String COMPACTED_PREFIX = "compacted-";
    private final int numCompactThreads;
    private final FileCompactor fileCompactor;
    private final CompactingFileWriter.Type compactingWriterType;
    private final BucketWriter<?, String> bucketWriter;
    private transient ExecutorService compactService;

    public CompactService(int numCompactThreads, FileCompactor fileCompactor, BucketWriter<?, String> bucketWriter) {
        this.numCompactThreads = numCompactThreads;
        this.fileCompactor = fileCompactor;
        this.bucketWriter = bucketWriter;
        this.compactingWriterType = CompactService.getWriterType(fileCompactor);
    }

    public void open() {
        this.compactService = Executors.newFixedThreadPool(Math.max(1, Math.min(this.numCompactThreads, Hardware.getNumberCPUCores())), (ThreadFactory)new ExecutorThreadFactory("compact-executor"));
    }

    public void submit(CompactorRequest request, CompletableFuture<Iterable<FileSinkCommittable>> resultFuture) {
        this.compactService.submit(() -> {
            try {
                Iterable<FileSinkCommittable> result = this.compact(request);
                resultFuture.complete(result);
            }
            catch (Exception e) {
                resultFuture.completeExceptionally(e);
            }
        });
    }

    public void close() {
        if (this.compactService != null) {
            this.compactService.shutdownNow();
        }
    }

    private Iterable<FileSinkCommittable> compact(CompactorRequest request) throws Exception {
        ArrayList<FileSinkCommittable> results = new ArrayList<FileSinkCommittable>(request.getCommittableToPassthrough());
        List<Path> compactingFiles = this.getCompactingPath(request);
        if (compactingFiles.isEmpty()) {
            return results;
        }
        Path targetPath = CompactService.assembleCompactedFilePath(compactingFiles.get(0));
        CompactingFileWriter compactingFileWriter = this.bucketWriter.openNewCompactingFile(this.compactingWriterType, (Object)request.getBucketId(), targetPath, System.currentTimeMillis());
        if (this.compactingWriterType == CompactingFileWriter.Type.RECORD_WISE) {
            ((RecordWiseFileCompactor)this.fileCompactor).compact(compactingFiles, arg_0 -> ((RecordWiseCompactingFileWriter)((RecordWiseCompactingFileWriter)compactingFileWriter)).write(arg_0));
        } else if (this.compactingWriterType == CompactingFileWriter.Type.OUTPUT_STREAM) {
            ((OutputStreamBasedFileCompactor)this.fileCompactor).compact(compactingFiles, ((OutputStreamBasedCompactingFileWriter)compactingFileWriter).asOutputStream());
        }
        InProgressFileWriter.PendingFileRecoverable compactedPendingFile = compactingFileWriter.closeForCommit();
        FileSinkCommittable compacted = new FileSinkCommittable(request.getBucketId(), compactedPendingFile);
        results.add(compacted);
        for (Path f : compactingFiles) {
            results.add(new FileSinkCommittable(request.getBucketId(), f));
        }
        return results;
    }

    private List<Path> getCompactingPath(CompactorRequest request) throws IOException {
        List<FileSinkCommittable> compactingCommittable = request.getCommittableToCompact();
        ArrayList<Path> compactingFiles = new ArrayList<Path>();
        for (FileSinkCommittable committable : compactingCommittable) {
            InProgressFileWriter.PendingFileRecoverable pendingFile = committable.getPendingFile();
            Preconditions.checkState((pendingFile != null ? 1 : 0) != 0, (Object)"Illegal committable to compact, pending file is null.");
            Path pendingPath = pendingFile.getPath();
            Preconditions.checkState((pendingPath != null && pendingPath.getName().startsWith(".") ? 1 : 0) != 0, (Object)("Illegal pending file to compact, path should start with . but is " + String.valueOf(pendingPath)));
            this.bucketWriter.recoverPendingFile(pendingFile).commitAfterRecovery();
            compactingFiles.add(pendingPath);
        }
        return compactingFiles;
    }

    private static Path assembleCompactedFilePath(Path uncompactedPath) {
        String uncompactedName = uncompactedPath.getName();
        if (uncompactedName.startsWith(".")) {
            uncompactedName = uncompactedName.substring(1);
        }
        return new Path(uncompactedPath.getParent(), COMPACTED_PREFIX + uncompactedName);
    }

    private static CompactingFileWriter.Type getWriterType(FileCompactor fileCompactor) {
        if (fileCompactor instanceof OutputStreamBasedFileCompactor) {
            return CompactingFileWriter.Type.OUTPUT_STREAM;
        }
        if (fileCompactor instanceof RecordWiseFileCompactor) {
            return CompactingFileWriter.Type.RECORD_WISE;
        }
        throw new UnsupportedOperationException("Unable to crate compacting file writer for compactor:" + String.valueOf(fileCompactor.getClass()));
    }
}

