/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.examples.java.basics;

import java.util.Arrays;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;

public final class StreamSQLExample {
    public static void main(String[] args) throws Exception {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tableEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource orderA = env.fromData(Arrays.asList(new Order(1L, "beer", 3), new Order(1L, "diaper", 4), new Order(3L, "rubber", 2)));
        DataStreamSource orderB = env.fromData(Arrays.asList(new Order(2L, "pen", 3), new Order(2L, "rubber", 3), new Order(4L, "beer", 1)));
        Table tableA = tableEnv.fromDataStream((DataStream)orderA);
        tableEnv.createTemporaryView("TableB", (DataStream)orderB);
        Table result = tableEnv.sqlQuery("SELECT * FROM " + String.valueOf(tableA) + " WHERE amount > 2 UNION ALL SELECT * FROM TableB WHERE amount < 2");
        tableEnv.toDataStream(result, Order.class).print();
        env.execute();
    }

    public static class Order {
        public Long user;
        public String product;
        public int amount;

        public Order() {
        }

        public Order(Long user, String product, int amount) {
            this.user = user;
            this.product = product;
            this.amount = amount;
        }

        public String toString() {
            return "Order{user=" + this.user + ", product='" + this.product + "', amount=" + this.amount + "}";
        }
    }
}

