/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.data.impl.meta;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.deltaspike.data.api.SingleResultType;

public class RepositoryMethodPrefix {
    public static final String DEFAULT_PREFIX = "findBy";
    public static final String DEFAULT_OPT_PREFIX = "findOptionalBy";
    public static final String DEFAULT_ANY_PREFIX = "findAnyBy";
    public static final String DEFAULT_DELETE_PREFIX = "deleteBy";
    public static final String DEFAULT_COUNT_PREFIX = "countBy";
    public static final String DEFAULT_REMOVE_PREFIX = "removeBy";
    private static final String FIND_ALL_PREFIX = "findAll";
    private static final String FIND_FIRST_PREFIX = "find(First|Top)(\\d+)(By)*";
    private static final String FIND_FIRST_PREFIX_PATTERN = "find(First|Top)(\\d+)(By)*(.*)";
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");
    private final String customPrefix;
    private final String methodName;
    private int definedMaxResults = 0;

    public RepositoryMethodPrefix(String customPrefix, String methodName) {
        this.customPrefix = customPrefix;
        this.methodName = methodName;
        if (this.methodName != null) {
            this.parseMaxResults();
        }
    }

    public String removePrefix(String queryPart) {
        if (this.hasCustomPrefix() && queryPart.startsWith(this.customPrefix)) {
            return queryPart.substring(this.customPrefix.length());
        }
        KnownQueryPrefix known = KnownQueryPrefix.fromMethodName(queryPart);
        if (known != null) {
            return known.removePrefix(queryPart);
        }
        return queryPart;
    }

    public boolean hasCustomPrefix() {
        return !"".equals(this.customPrefix);
    }

    public String getCustomPrefix() {
        return this.customPrefix;
    }

    public String getPrefix() {
        if (this.hasCustomPrefix()) {
            return this.customPrefix;
        }
        KnownQueryPrefix prefix = KnownQueryPrefix.fromMethodName(this.methodName);
        if (prefix != null) {
            return prefix.getPrefix();
        }
        return "";
    }

    public SingleResultType getSingleResultStyle() {
        KnownQueryPrefix prefix = KnownQueryPrefix.fromMethodName(this.methodName);
        if (prefix != null) {
            return prefix.getStyle();
        }
        return SingleResultType.JPA;
    }

    public boolean isDelete() {
        return this.getPrefix().equalsIgnoreCase(DEFAULT_DELETE_PREFIX) || this.getPrefix().equalsIgnoreCase(DEFAULT_REMOVE_PREFIX);
    }

    public boolean isCount() {
        return this.getPrefix().equalsIgnoreCase(DEFAULT_COUNT_PREFIX);
    }

    public int getDefinedMaxResults() {
        return this.definedMaxResults;
    }

    private void parseMaxResults() {
        Matcher matcher;
        if (this.methodName.matches(FIND_FIRST_PREFIX_PATTERN) && (matcher = DIGIT_PATTERN.matcher(this.methodName)).find()) {
            this.definedMaxResults = Integer.parseInt(matcher.group());
        }
    }

    private static enum KnownQueryPrefix {
        DEFAULT("findBy", SingleResultType.JPA),
        ALL("findAll", SingleResultType.JPA),
        FIND_FIRST("find(First|Top)(\\d+)(By)*", SingleResultType.JPA){

            @Override
            public boolean matches(String name) {
                return name.matches(RepositoryMethodPrefix.FIND_FIRST_PREFIX_PATTERN);
            }

            @Override
            public String removePrefix(String queryPart) {
                return queryPart.replaceFirst(RepositoryMethodPrefix.FIND_FIRST_PREFIX, "");
            }
        }
        ,
        OPTIONAL("findOptionalBy", SingleResultType.OPTIONAL),
        ANY("findAnyBy", SingleResultType.ANY),
        DELETE_DEFAULT("deleteBy", SingleResultType.ANY),
        REMOVE_DEFAULT("removeBy", SingleResultType.ANY),
        COUNT_DEFAULT("countBy", SingleResultType.ANY);

        private final String prefix;
        private final SingleResultType singleResultType;

        private KnownQueryPrefix(String prefix, SingleResultType singleResultType) {
            this.prefix = prefix;
            this.singleResultType = singleResultType;
        }

        public String removePrefix(String queryPart) {
            return queryPart.substring(this.prefix.length());
        }

        public String getPrefix() {
            return this.prefix;
        }

        public SingleResultType getStyle() {
            return this.singleResultType;
        }

        public boolean matches(String name) {
            return name.startsWith(this.getPrefix());
        }

        public static KnownQueryPrefix fromMethodName(String name) {
            for (KnownQueryPrefix mapping : KnownQueryPrefix.values()) {
                if (!mapping.matches(name)) continue;
                return mapping;
            }
            return null;
        }
    }
}

