/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config.converter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import org.apache.deltaspike.core.api.config.Config;
import org.apache.deltaspike.core.api.config.ConfigProperty;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.util.ExceptionUtils;

public class FieldInjectionBeanConverter<N>
implements BiFunction<Config, String, N> {
    private final Class<?> clazz;
    private final List<Field> fields;

    public <N> FieldInjectionBeanConverter(Class<N> clazz) {
        this.clazz = clazz;
        this.fields = this.collectFields(clazz);
    }

    private <N> List<Field> collectFields(Class<N> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (clazz.getSuperclass() != Object.class) {
            fields.addAll(this.collectFields(clazz.getSuperclass()));
        }
        return fields;
    }

    @Override
    public N apply(Config config, String path) {
        try {
            Object o = this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field field : this.fields) {
                ConfigProperty configProperty = field.getAnnotation(ConfigProperty.class);
                String name = configProperty != null ? configProperty.name() : field.getName();
                ConfigResolver.UntypedResolver resolver = config.resolve(path + name);
                if (field.getType() != String.class) {
                    resolver.as(field.getType());
                }
                resolver.evaluateVariables(configProperty != null ? configProperty.evaluateVariables() : true);
                resolver.withCurrentProjectStage(configProperty != null ? configProperty.projectStageAware() : true);
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(o, resolver.getValue());
            }
            return (N)o;
        }
        catch (Exception e) {
            throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
        }
    }
}

