/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.Topic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.transport.jms.JMSPropertyType;

public class JMSMessageHeadersType {
    private Map<String, Object> properties = new HashMap<String, Object>();
    private String jmsCorrelationID;
    private Integer jmsDeliveryMode;
    private Long jmsExpiration;
    private String jmsMessageID;
    private Integer jmsPriority;
    private Boolean jmsRedelivered;
    private String jmsReplyTo;
    private Long jmsTimeStamp;
    private String jmsType;
    private Long timeToLive;
    private String soapjmsTargetService;
    private String soapjmsBindingVersion;
    private String soapjmsContentType;
    private String soapjmsContentEncoding;
    private String soapjmssoapAction;
    private Boolean soapjmsIsFault;
    private String soapjmsRequestURI;

    @Deprecated
    public List<JMSPropertyType> getProperty() {
        ArrayList<JMSPropertyType> props = new ArrayList<JMSPropertyType>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            JMSPropertyType prop = new JMSPropertyType();
            prop.setName(entry.getKey());
            prop.setValue(entry.getValue());
            props.add(prop);
        }
        return Collections.unmodifiableList(props);
    }

    public void putProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public Set<String> getPropertyKeys() {
        return this.properties.keySet();
    }

    public String getJMSCorrelationID() {
        return this.jmsCorrelationID;
    }

    public void setJMSCorrelationID(String value) {
        this.jmsCorrelationID = value;
    }

    public boolean isSetJMSCorrelationID() {
        return this.jmsCorrelationID != null;
    }

    public String getJMSMessageID() {
        return this.jmsMessageID;
    }

    public void setJMSMessageID(String value) {
        this.jmsMessageID = value;
    }

    public boolean isSetJMSMessageID() {
        return this.jmsMessageID != null;
    }

    public String getJMSReplyTo() {
        return this.jmsReplyTo;
    }

    public void setJMSReplyTo(String value) {
        this.jmsReplyTo = value;
    }

    public boolean isSetJMSReplyTo() {
        return this.jmsReplyTo != null;
    }

    public String getJMSType() {
        return this.jmsType;
    }

    public void setJMSType(String value) {
        this.jmsType = value;
    }

    public boolean isSetJMSType() {
        return this.jmsType != null;
    }

    public String getSOAPJMSTargetService() {
        return this.soapjmsTargetService;
    }

    public void setSOAPJMSTargetService(String value) {
        this.soapjmsTargetService = value;
    }

    public boolean isSetSOAPJMSTargetService() {
        return this.soapjmsTargetService != null;
    }

    public String getSOAPJMSBindingVersion() {
        return this.soapjmsBindingVersion;
    }

    public void setSOAPJMSBindingVersion(String value) {
        this.soapjmsBindingVersion = value;
    }

    public boolean isSetSOAPJMSBindingVersion() {
        return this.soapjmsBindingVersion != null;
    }

    public String getSOAPJMSContentType() {
        return this.soapjmsContentType;
    }

    public void setSOAPJMSContentType(String value) {
        this.soapjmsContentType = value;
    }

    public boolean isSetSOAPJMSContentType() {
        return this.soapjmsContentType != null;
    }

    public String getSOAPJMSContentEncoding() {
        return this.soapjmsContentEncoding;
    }

    public void setSOAPJMSContentEncoding(String value) {
        this.soapjmsContentEncoding = value;
    }

    public boolean isSetSOAPJMSContentEncoding() {
        return this.soapjmsContentEncoding != null;
    }

    public String getSOAPJMSSOAPAction() {
        return this.soapjmssoapAction;
    }

    public void setSOAPJMSSOAPAction(String value) {
        this.soapjmssoapAction = value;
    }

    public boolean isSetSOAPJMSSOAPAction() {
        return this.soapjmssoapAction != null;
    }

    public String getSOAPJMSRequestURI() {
        return this.soapjmsRequestURI;
    }

    public void setSOAPJMSRequestURI(String value) {
        this.soapjmsRequestURI = value;
    }

    public boolean isSetSOAPJMSRequestURI() {
        return this.soapjmsRequestURI != null;
    }

    public void setJMSDeliveryMode(int value) {
        this.jmsDeliveryMode = value;
    }

    public void unsetJMSDeliveryMode() {
        this.jmsDeliveryMode = null;
    }

    public boolean isSetJMSDeliveryMode() {
        return this.jmsDeliveryMode != null;
    }

    public int getJMSDeliveryMode() {
        return this.jmsDeliveryMode;
    }

    public void setJMSExpiration(long value) {
        this.jmsExpiration = value;
    }

    public void unsetJMSExpiration() {
        this.jmsExpiration = null;
    }

    public boolean isSetJMSExpiration() {
        return this.jmsExpiration != null;
    }

    public long getJMSExpiration() {
        return this.jmsExpiration;
    }

    public void setJMSPriority(int value) {
        this.jmsPriority = value;
    }

    public void unsetJMSPriority() {
        this.jmsPriority = null;
    }

    public boolean isSetJMSPriority() {
        return this.jmsPriority != null;
    }

    public int getJMSPriority() {
        return this.jmsPriority;
    }

    public void setJMSRedelivered(boolean value) {
        this.jmsRedelivered = value;
    }

    public void unsetJMSRedelivered() {
        this.jmsRedelivered = null;
    }

    public boolean isSetJMSRedelivered() {
        return this.jmsRedelivered != null;
    }

    public boolean isJMSRedelivered() {
        return this.jmsRedelivered;
    }

    public void setJMSTimeStamp(long value) {
        this.jmsTimeStamp = value;
    }

    public void unsetJMSTimeStamp() {
        this.jmsTimeStamp = null;
    }

    public boolean isSetJMSTimeStamp() {
        return this.jmsTimeStamp != null;
    }

    public long getJMSTimeStamp() {
        return this.jmsTimeStamp;
    }

    public void setTimeToLive(long value) {
        this.timeToLive = value;
    }

    public void unsetTimeToLive() {
        this.timeToLive = null;
    }

    public boolean isSetTimeToLive() {
        return this.timeToLive != null;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setSOAPJMSIsFault(boolean value) {
        this.soapjmsIsFault = value;
    }

    public void unsetSOAPJMSIsFault() {
        this.soapjmsIsFault = null;
    }

    public boolean isSetSOAPJMSIsFault() {
        return this.soapjmsIsFault != null;
    }

    public boolean isSOAPJMSIsFault() {
        return this.soapjmsIsFault;
    }

    public String getContentType() {
        String contentType = this.getSOAPJMSContentType();
        if (contentType == null) {
            contentType = (String)this.getProperty("SOAPJMS_contentType");
        }
        if (contentType == null) {
            contentType = (String)this.getProperty("org.apache.cxf.jms.rs.ContentType");
        }
        if (contentType == null) {
            contentType = (String)this.getProperty("Content-Type");
        }
        return contentType;
    }

    public static JMSMessageHeadersType from(Message message) throws JMSException {
        JMSMessageHeadersType messageHeaders = new JMSMessageHeadersType();
        messageHeaders.read(message);
        return messageHeaders;
    }

    private void read(Message message) throws JMSException {
        this.setJMSCorrelationID(message.getJMSCorrelationID());
        this.setJMSDeliveryMode(message.getJMSDeliveryMode());
        this.setJMSExpiration(message.getJMSExpiration());
        this.setJMSMessageID(message.getJMSMessageID());
        this.setJMSPriority(message.getJMSPriority());
        this.setJMSRedelivered(message.getJMSRedelivered());
        this.setJMSTimeStamp(message.getJMSTimestamp());
        this.setJMSType(message.getJMSType());
        this.setSOAPJMSTargetService(message.getStringProperty("SOAPJMS_targetService"));
        this.setSOAPJMSBindingVersion(message.getStringProperty("SOAPJMS_bindingVersion"));
        this.setSOAPJMSContentType(message.getStringProperty("SOAPJMS_contentType"));
        this.setSOAPJMSContentEncoding(message.getStringProperty("SOAPJMS_contentEncoding"));
        this.setSOAPJMSSOAPAction(message.getStringProperty("SOAPJMS_soapAction"));
        if (message.propertyExists("SOAPJMS_isFault")) {
            this.setSOAPJMSIsFault(message.getBooleanProperty("SOAPJMS_isFault"));
        }
        this.setSOAPJMSRequestURI(message.getStringProperty("SOAPJMS_requestURI"));
        this.setJMSReplyTo(this.getDestName(message));
        this.readProperties(message);
    }

    private String getDestName(Message message) throws JMSException {
        Destination replyTo = message.getJMSReplyTo();
        if (replyTo instanceof Queue) {
            return ((Queue)replyTo).getQueueName();
        }
        if (replyTo instanceof Topic) {
            return ((Topic)replyTo).getTopicName();
        }
        return null;
    }

    private void readProperties(Message message) throws JMSException {
        Enumeration enm = CastUtils.cast((Enumeration)message.getPropertyNames());
        while (enm.hasMoreElements()) {
            String name = (String)enm.nextElement();
            String val = message.getStringProperty(name);
            String unescapedName = name.replace("_$_", "-").replace("__", ".");
            this.putProperty(unescapedName, val);
        }
    }

    public void writeProp(Message jmsMessage, String origName, Object value) throws JMSException {
        String name = origName.replace(".", "__").replace("-", "_$_");
        if (value == null) {
            jmsMessage.setStringProperty(name, null);
            return;
        }
        Class<?> cls = value.getClass();
        if (cls == String.class) {
            jmsMessage.setStringProperty(name, (String)value);
        } else if (cls == Integer.TYPE || cls == Integer.class) {
            jmsMessage.setIntProperty(name, ((Integer)value).intValue());
        } else if (cls == Double.TYPE || cls == Double.class) {
            jmsMessage.setDoubleProperty(name, ((Double)value).doubleValue());
        } else if (cls == Float.TYPE || cls == Float.class) {
            jmsMessage.setFloatProperty(name, ((Float)value).floatValue());
        } else if (cls == Long.TYPE || cls == Long.class) {
            jmsMessage.setLongProperty(name, ((Long)value).longValue());
        } else if (cls == Boolean.TYPE || cls == Boolean.class) {
            jmsMessage.setBooleanProperty(name, ((Boolean)value).booleanValue());
        } else if (cls == Short.TYPE || cls == Short.class) {
            jmsMessage.setShortProperty(name, ((Short)value).shortValue());
        } else if (cls == Byte.TYPE || cls == Byte.class) {
            jmsMessage.setShortProperty(name, (short)((Byte)value).byteValue());
        } else {
            jmsMessage.setObjectProperty(name, value);
        }
    }

    public void writeTo(Message jmsMessage) throws JMSException {
        this.setProp(jmsMessage, "SOAPJMS_targetService", this.soapjmsTargetService);
        this.setProp(jmsMessage, "SOAPJMS_bindingVersion", this.soapjmsBindingVersion);
        this.setProp(jmsMessage, "SOAPJMS_contentType", this.soapjmsContentType);
        this.setProp(jmsMessage, "SOAPJMS_contentEncoding", this.soapjmsContentEncoding);
        this.setProp(jmsMessage, "SOAPJMS_soapAction", this.soapjmssoapAction);
        this.setProp(jmsMessage, "SOAPJMS_requestURI", this.soapjmsRequestURI);
        if (this.isSetSOAPJMSIsFault()) {
            jmsMessage.setBooleanProperty("SOAPJMS_isFault", this.isSOAPJMSIsFault());
        }
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            this.writeProp(jmsMessage, entry.getKey(), entry.getValue());
        }
    }

    private void setProp(Message jmsMessage, String name, String value) throws JMSException {
        if (value != null) {
            jmsMessage.setStringProperty(name, value);
        }
    }
}

