/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.script.ScriptContext;
import javax.script.ScriptException;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedConsumer<T>
extends AbstractScriptEvaluator
implements Consumer<T> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedConsumer.class);
    @Nullable
    private Class<T> inputTypeClass;

    protected ScriptedConsumer(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript, @Nullable @ParameterName(name="extraInfo") @NotEmpty String extraInfo) {
        super(theScript);
        this.setLogPrefix("Scripted Consumer from " + extraInfo + ":");
    }

    protected ScriptedConsumer(@Nonnull @ParameterName(name="theScript") @NotEmpty EvaluableScript theScript) {
        super(theScript);
        this.setLogPrefix("Anonymous Consumer:");
    }

    @Nullable
    public Class<T> getInputType() {
        return this.inputTypeClass;
    }

    public void setInputType(@Nullable Class<T> type) {
        this.inputTypeClass = type;
    }

    @Override
    public void accept(@Nullable T input) {
        if (null != this.getInputType() && null != input && !this.getInputType().isInstance(input)) {
            this.log.error("{} Input of type {} was not of type {}", new Object[]{this.getLogPrefix(), input.getClass(), this.getInputType()});
        } else {
            this.evaluate(input);
        }
    }

    @Override
    protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        scriptContext.setAttribute("input", input[0], 100);
    }

    public static <T> ScriptedConsumer<T> resourceScript(@Nonnull @NotEmpty String engineName, @Nonnull Resource resource) throws ScriptException, IOException {
        try (InputStream is = resource.getInputStream();){
            EvaluableScript script = new EvaluableScript();
            script.setEngineName(engineName);
            script.setScript(is);
            script.initializeWithScriptException();
            ScriptedConsumer<T> scriptedConsumer = new ScriptedConsumer<T>(script, resource.getDescription());
            return scriptedConsumer;
        }
    }

    public static <T> ScriptedConsumer<T> resourceScript(Resource resource) throws ScriptException, IOException {
        return ScriptedConsumer.resourceScript("JavaScript", resource);
    }

    public static <T> ScriptedConsumer<T> inlineScript(@Nonnull @NotEmpty String engineName, @Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setEngineName(engineName);
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedConsumer<T>(script, "Inline");
    }

    public static <T> ScriptedConsumer<T> inlineScript(@Nonnull @NotEmpty String scriptSource) throws ScriptException {
        EvaluableScript script = new EvaluableScript();
        script.setScript(scriptSource);
        script.initializeWithScriptException();
        return new ScriptedConsumer<T>(script, "Inline");
    }
}

