/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.impl;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;

final class BackupTopologyListener
implements ClusterTopologyListener {
    private final CountDownLatch latch = new CountDownLatch(1);
    private final String ownId;
    private static final int WAIT_TIMEOUT = 60;
    private final TransportConfiguration myTc;

    BackupTopologyListener(String ownId, TransportConfiguration nodeTransportConfig) {
        this.ownId = ownId;
        this.myTc = nodeTransportConfig;
    }

    public void nodeUP(TopologyMember topologyMember, boolean last) {
        if (this.myTc.equals((Object)topologyMember.getBackup())) {
            return;
        }
        String nodeID = topologyMember.getNodeId();
        if (this.ownId.equals(nodeID) && topologyMember.getBackup() != null) {
            this.latch.countDown();
        }
    }

    public void nodeDown(long eventUID, String nodeID) {
    }

    boolean waitForBackup() {
        try {
            return this.latch.await(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

