/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.amqpBrokerConnectivity;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBridgeBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionAddressType;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPFederatedBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPMirrorBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPPeerBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPReceiverBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.amqpBrokerConnectivity.AMQPSenderBrokerConnectionElement;
import org.apache.activemq.artemis.core.config.brokerConnectivity.BrokerConnectConfiguration;
import org.apache.activemq.artemis.uri.ConnectorTransportConfigurationParser;

public class AMQPBrokerConnectConfiguration
extends BrokerConnectConfiguration {
    private static final long serialVersionUID = 8827214279279810938L;
    List<TransportConfiguration> transportConfigurations;
    List<AMQPBrokerConnectionElement> connectionElements = new ArrayList<AMQPBrokerConnectionElement>();

    public AMQPBrokerConnectConfiguration() {
        super(null, null);
    }

    public AMQPBrokerConnectConfiguration(String name, String uri) {
        super(name, uri);
    }

    public AMQPBrokerConnectConfiguration addElement(AMQPBrokerConnectionElement amqpBrokerConnectionElement) {
        amqpBrokerConnectionElement.setParent(this);
        if (amqpBrokerConnectionElement.getType() == AMQPBrokerConnectionAddressType.MIRROR && !(amqpBrokerConnectionElement instanceof AMQPMirrorBrokerConnectionElement)) {
            throw new IllegalArgumentException("must be an AMQPMirrorConnectionElement");
        }
        this.connectionElements.add(amqpBrokerConnectionElement);
        return this;
    }

    public AMQPBrokerConnectConfiguration addConnectionElement(AMQPMirrorBrokerConnectionElement amqpBrokerConnectionElement) {
        return this.addElement(amqpBrokerConnectionElement);
    }

    public List<AMQPBrokerConnectionElement> getConnectionElements() {
        return this.connectionElements;
    }

    public AMQPBrokerConnectConfiguration addFederation(AMQPFederatedBrokerConnectionElement amqpFederationElement) {
        return this.addElement(amqpFederationElement);
    }

    public List<AMQPBrokerConnectionElement> getFederations() {
        return this.connectionElements;
    }

    public AMQPBrokerConnectConfiguration addBridge(AMQPBridgeBrokerConnectionElement amqpBridgeElement) {
        return this.addElement(amqpBridgeElement);
    }

    public List<AMQPBrokerConnectionElement> getBridges() {
        return this.connectionElements;
    }

    public AMQPBrokerConnectConfiguration addMirror(AMQPMirrorBrokerConnectionElement amqpMirrorBrokerConnectionElement) {
        return this.addElement(amqpMirrorBrokerConnectionElement);
    }

    public List<AMQPBrokerConnectionElement> getMirrors() {
        return this.connectionElements;
    }

    public AMQPBrokerConnectConfiguration addPeer(AMQPPeerBrokerConnectionElement element) {
        return this.addElement(element);
    }

    public List<AMQPBrokerConnectionElement> getPeers() {
        return this.connectionElements;
    }

    public AMQPBrokerConnectConfiguration addSender(AMQPSenderBrokerConnectionElement element) {
        return this.addElement(element);
    }

    public List<AMQPBrokerConnectionElement> getSenders() {
        return this.connectionElements;
    }

    public AMQPBrokerConnectConfiguration addReceiver(AMQPReceiverBrokerConnectionElement element) {
        return this.addElement(element);
    }

    public List<AMQPBrokerConnectionElement> getReceivers() {
        return this.connectionElements;
    }

    @Override
    public void parseURI() throws Exception {
        ConnectorTransportConfigurationParser parser = new ConnectorTransportConfigurationParser(false);
        URI transportURI = parser.expandURI(this.getUri());
        this.transportConfigurations = (List)parser.newObject(transportURI, (Object)this.getName());
    }

    public List<TransportConfiguration> getTransportConfigurations() throws Exception {
        if (this.transportConfigurations == null) {
            this.parseURI();
        }
        return this.transportConfigurations;
    }

    @Override
    public AMQPBrokerConnectConfiguration setReconnectAttempts(int reconnectAttempts) {
        super.setReconnectAttempts(reconnectAttempts);
        return this;
    }

    @Override
    public AMQPBrokerConnectConfiguration setUser(String user) {
        super.setUser(user);
        return this;
    }

    @Override
    public AMQPBrokerConnectConfiguration setRetryInterval(int retryInterval) {
        super.setRetryInterval(retryInterval);
        return this;
    }

    @Override
    public AMQPBrokerConnectConfiguration setPassword(String password) {
        super.setPassword(password);
        return this;
    }

    @Override
    public AMQPBrokerConnectConfiguration setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public AMQPBrokerConnectConfiguration setName(String name) {
        super.setName(name);
        return this;
    }

    @Override
    public AMQPBrokerConnectConfiguration setAutostart(boolean autostart) {
        super.setAutostart(autostart);
        return this;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.connectionElements, this.transportConfigurations);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AMQPBrokerConnectConfiguration)) {
            return false;
        }
        AMQPBrokerConnectConfiguration other = (AMQPBrokerConnectConfiguration)obj;
        return Objects.equals(this.connectionElements, other.connectionElements) && Objects.equals(this.transportConfigurations, other.transportConfigurations);
    }
}

