/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.types.CorbaEnumHandler;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaPrimitiveHandler;
import org.apache.cxf.binding.corba.wsdl.CaseType;
import org.apache.cxf.binding.corba.wsdl.Enum;
import org.apache.cxf.binding.corba.wsdl.Enumerator;
import org.apache.cxf.binding.corba.wsdl.Union;
import org.apache.cxf.binding.corba.wsdl.Unionbranch;
import org.omg.CORBA.TypeCode;

public class CorbaUnionHandler
extends CorbaObjectHandler {
    private CorbaObjectHandler discriminator;
    private CorbaObjectHandler value;
    private List<CorbaObjectHandler> cases = new ArrayList<CorbaObjectHandler>();
    private int defaultIndex;
    private List<String> labels = new ArrayList<String>();

    public CorbaUnionHandler(QName unionName, QName unionIdlType, TypeCode unionTC, Object unionType) {
        super(unionName, unionIdlType, unionTC, unionType);
        Union union = (Union)unionType;
        List<Unionbranch> branches = union.getUnionbranch();
        int index = 0;
        for (Unionbranch branch : branches) {
            List<CaseType> branchCases = branch.getCase();
            if (branchCases.isEmpty()) {
                this.defaultIndex = index;
            } else {
                for (CaseType ct : branchCases) {
                    this.labels.add(ct.getLabel());
                }
            }
            ++index;
        }
    }

    public CorbaObjectHandler getDiscriminator() {
        return this.discriminator;
    }

    public String getDisciminatorValueData() {
        String result;
        if (this.discriminator.getTypeCodeKind().value() == 17) {
            CorbaEnumHandler enumHandler = (CorbaEnumHandler)this.discriminator;
            result = enumHandler.getValue();
        } else {
            CorbaPrimitiveHandler primitiveHandler = (CorbaPrimitiveHandler)this.discriminator;
            result = primitiveHandler.getDataFromValue();
        }
        return result;
    }

    public void setDiscriminator(CorbaObjectHandler disc) {
        this.discriminator = disc;
    }

    public void setDiscriminatorValueFromData(String data) {
        if (this.discriminator.getTypeCodeKind().value() == 17) {
            CorbaEnumHandler enumHandler = (CorbaEnumHandler)this.discriminator;
            enumHandler.setValue(data);
        } else {
            CorbaPrimitiveHandler primitiveHandler = (CorbaPrimitiveHandler)this.discriminator;
            primitiveHandler.setValueFromData(data);
        }
    }

    public List<CorbaObjectHandler> getCases() {
        return this.cases;
    }

    public CorbaObjectHandler getBranchByName(String caseName) {
        for (CorbaObjectHandler obj : this.cases) {
            if (!obj.getName().getLocalPart().equals(caseName)) continue;
            return obj;
        }
        return null;
    }

    public void addCase(CorbaObjectHandler unionCase) {
        this.cases.add(unionCase);
    }

    public CorbaObjectHandler getValue() {
        return this.value;
    }

    public void setValue(String caseName, CorbaObjectHandler val) {
        this.value = val;
    }

    public int getDefaultIndex() {
        return this.defaultIndex;
    }

    public String createDefaultDiscriminatorLabel() {
        String label;
        block10: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            boolean boolValue;
                            label = null;
                            if (this.discriminator.getTypeCodeKind().value() != 8) break block11;
                            label = this.labels.isEmpty() ? "false" : String.valueOf(!(boolValue = Boolean.parseBoolean(this.labels.get(0))));
                            break block10;
                        }
                        if (this.discriminator.getTypeCodeKind().value() != 9) break block12;
                        if (this.labels.isEmpty()) {
                            label = String.valueOf('0');
                        } else {
                            char charValue = this.labels.get(0).charAt(0);
                            while (this.labels.contains(String.valueOf(charValue))) {
                                charValue = (char)(charValue + '\u0001');
                            }
                            label = String.valueOf(charValue);
                        }
                        break block10;
                    }
                    if (this.discriminator.getTypeCodeKind().value() != 17) break block13;
                    Enum enumType = (Enum)this.discriminator.getType();
                    List<Enumerator> enumerators = enumType.getEnumerator();
                    if (this.labels.isEmpty()) {
                        label = enumerators.get(0).getValue();
                    } else {
                        Iterator<Enumerator> enumIter = enumerators.iterator();
                        while (enumIter.hasNext()) {
                            String enumLabel = enumIter.next().getValue();
                            if (this.labels.contains(enumLabel)) continue;
                            label = enumLabel;
                            break block10;
                        }
                    }
                    break block10;
                }
                if (this.discriminator.getTypeCodeKind().value() != 2 && this.discriminator.getTypeCodeKind().value() != 4) break block14;
                if (this.labels.isEmpty()) {
                    label = String.valueOf(Short.MAX_VALUE);
                }
                for (int i = Short.MAX_VALUE; i >= Short.MIN_VALUE; --i) {
                    if (this.labels.contains(String.valueOf(i))) continue;
                    label = String.valueOf(i);
                    break block10;
                }
                break block10;
            }
            if (this.discriminator.getTypeCodeKind().value() != 3 && this.discriminator.getTypeCodeKind().value() != 5) break block10;
            if (this.labels.isEmpty()) {
                label = String.valueOf(Integer.MAX_VALUE);
            }
            for (int i = Integer.MAX_VALUE; i >= Integer.MIN_VALUE; --i) {
                if (this.labels.contains(String.valueOf(i))) continue;
                label = String.valueOf(i);
                break;
            }
        }
        return label;
    }

    @Override
    public void clear() {
        if (this.discriminator != null) {
            this.discriminator.clear();
        }
        if (this.value != null) {
            this.value.clear();
        }
    }
}

