/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.interceptors;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.corba.CorbaMessage;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.interceptors.CorbaStreamOutEndingInterceptor;
import org.apache.cxf.binding.corba.runtime.CorbaStreamWriter;
import org.apache.cxf.binding.corba.utils.ContextUtils;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.binding.corba.wsdl.ModeType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

public class CorbaStreamOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private ORB orb;
    private CorbaTypeMap typeMap;
    private ServiceInfo service;

    public CorbaStreamOutInterceptor() {
        super("pre-stream");
    }

    public void handleMessage(Message msg) {
        CorbaMessage message = (CorbaMessage)msg;
        this.orb = (ORB)message.get("orb");
        Exchange exchange = message.getExchange();
        this.service = exchange.getEndpoint().getEndpointInfo().getService();
        this.typeMap = message.getCorbaTypeMap();
        BindingOperationInfo boi = exchange.getBindingOperationInfo();
        if (ContextUtils.isRequestor((Message)message)) {
            this.handleOutBoundMessage(message, boi);
        } else {
            this.handleInBoundMessage(message, boi);
        }
        message.getInterceptorChain().add((Interceptor)new CorbaStreamOutEndingInterceptor());
    }

    private void handleOutBoundMessage(CorbaMessage message, BindingOperationInfo boi) {
        boolean wrap = false;
        if (boi.isUnwrappedCapable()) {
            wrap = true;
        }
        OperationType opType = (OperationType)boi.getExtensor(OperationType.class);
        List<ParamType> paramTypes = opType.getParam();
        ArrayList<ArgType> params = new ArrayList<ArgType>();
        for (ParamType param : paramTypes) {
            if (param.getMode().equals((Object)ModeType.OUT)) continue;
            params.add(param);
        }
        CorbaStreamWriter writer = new CorbaStreamWriter(this.orb, params, this.typeMap, this.service, wrap);
        message.setContent(XMLStreamWriter.class, writer);
    }

    private void handleInBoundMessage(CorbaMessage message, BindingOperationInfo boi) {
        boolean wrap = false;
        if (boi.isUnwrappedCapable()) {
            wrap = true;
        }
        OperationType opType = (OperationType)boi.getExtensor(OperationType.class);
        ArgType returnParam = opType.getReturn();
        List<ParamType> paramTypes = opType.getParam();
        ArrayList<ArgType> params = new ArrayList<ArgType>();
        if (returnParam != null) {
            params.add(returnParam);
        }
        for (ParamType param : paramTypes) {
            if (param.getMode().equals((Object)ModeType.IN)) continue;
            params.add(param);
        }
        CorbaStreamWriter writer = new CorbaStreamWriter(this.orb, params, this.typeMap, this.service, wrap);
        message.setContent(XMLStreamWriter.class, writer);
    }
}

