/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.server;

import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ProblemDetail;
import org.springframework.lang.Nullable;
import org.springframework.web.ErrorResponseException;

public class ResponseStatusException
extends ErrorResponseException {
    @Nullable
    private final String reason;

    public ResponseStatusException(HttpStatusCode status) {
        this(status, (String)null);
    }

    public ResponseStatusException(HttpStatusCode status, @Nullable String reason) {
        this(status, reason, null);
    }

    public ResponseStatusException(int rawStatusCode, @Nullable String reason, @Nullable Throwable cause) {
        this(HttpStatusCode.valueOf(rawStatusCode), reason, cause);
    }

    public ResponseStatusException(HttpStatusCode status, @Nullable String reason, @Nullable Throwable cause) {
        this(status, reason, cause, null, null);
    }

    protected ResponseStatusException(HttpStatusCode status, @Nullable String reason, @Nullable Throwable cause, @Nullable String messageDetailCode, @Nullable Object[] messageDetailArguments) {
        super(status, ProblemDetail.forStatus(status), cause, messageDetailCode, messageDetailArguments);
        this.reason = reason;
        this.setDetail(reason);
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Override
    public HttpHeaders getHeaders() {
        return this.getResponseHeaders();
    }

    @Deprecated(since="6.0")
    public HttpHeaders getResponseHeaders() {
        return HttpHeaders.EMPTY;
    }

    @Override
    public String getMessage() {
        return this.getStatusCode() + (String)(this.reason != null ? " \"" + this.reason + "\"" : "");
    }
}

