/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.jsr107.internal;

import java.util.HashMap;
import org.ehcache.jsr107.Jsr107Service;
import org.ehcache.jsr107.config.ConfigurationElementState;
import org.ehcache.jsr107.config.Jsr107Configuration;
import org.ehcache.jsr107.internal.Jsr107Parser;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.osgi.service.component.annotations.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Component
public class Jsr107ServiceConfigurationParser
extends Jsr107Parser<Jsr107Configuration>
implements CacheManagerServiceConfigurationParser<Jsr107Service, Jsr107Configuration> {
    private static final String ENABLE_MANAGEMENT_ALL_ATTRIBUTE = "enable-management";
    private static final String JSR_107_COMPLIANT_ATOMICS_ATTRIBUTE = "jsr-107-compliant-atomics";
    private static final String ENABLE_STATISTICS_ALL_ATTRIBUTE = "enable-statistics";
    private static final String DEFAULT_TEMPLATE_ATTRIBUTE = "default-template";
    private static final String CACHE_NAME_ATTRIBUTE = "name";
    private static final String TEMPLATE_NAME_ATTRIBUTE = "template";

    @Override
    public Jsr107Configuration parse(Element fragment, ClassLoader classLoader) {
        boolean jsr107CompliantAtomics = true;
        ConfigurationElementState enableManagementAll = ConfigurationElementState.UNSPECIFIED;
        ConfigurationElementState enableStatisticsAll = ConfigurationElementState.UNSPECIFIED;
        if (fragment.hasAttribute(JSR_107_COMPLIANT_ATOMICS_ATTRIBUTE)) {
            jsr107CompliantAtomics = Boolean.parseBoolean(fragment.getAttribute(JSR_107_COMPLIANT_ATOMICS_ATTRIBUTE));
        }
        if (fragment.hasAttribute(ENABLE_MANAGEMENT_ALL_ATTRIBUTE)) {
            ConfigurationElementState configurationElementState = enableManagementAll = Boolean.parseBoolean(fragment.getAttribute(ENABLE_MANAGEMENT_ALL_ATTRIBUTE)) ? ConfigurationElementState.ENABLED : ConfigurationElementState.DISABLED;
        }
        if (fragment.hasAttribute(ENABLE_STATISTICS_ALL_ATTRIBUTE)) {
            enableStatisticsAll = Boolean.parseBoolean(fragment.getAttribute(ENABLE_STATISTICS_ALL_ATTRIBUTE)) ? ConfigurationElementState.ENABLED : ConfigurationElementState.DISABLED;
        }
        String defaultTemplate = fragment.getAttribute(DEFAULT_TEMPLATE_ATTRIBUTE);
        HashMap<String, String> templates = new HashMap<String, String>();
        NodeList childNodes = fragment.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node node = childNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element item = (Element)node;
            templates.put(item.getAttribute(CACHE_NAME_ATTRIBUTE), item.getAttribute(TEMPLATE_NAME_ATTRIBUTE));
        }
        return new Jsr107Configuration(defaultTemplate, templates, jsr107CompliantAtomics, enableManagementAll, enableStatisticsAll);
    }

    @Override
    public Class<Jsr107Service> getServiceType() {
        return Jsr107Service.class;
    }

    @Override
    public Element safeUnparse(Document target, Jsr107Configuration serviceCreationConfiguration) {
        throw new XmlConfigurationException("XML translation of JSR-107 cache elements are not supported");
    }
}

