/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.lang.annotation.ElementType;
import java.lang.instrument.ClassDefinition;
import java.lang.invoke.CallSite;
import java.lang.management.BufferPoolMXBean;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.JexlTestCase;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.introspection.ClassTool;
import org.apache.commons.jexl3.internal.introspection.Permissions;
import org.apache.commons.jexl3.internal.introspection.Uberspect;
import org.apache.commons.jexl3.internal.introspection.nojexlpackage.Invisible;
import org.apache.commons.jexl3.introspection.JexlPermissions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PermissionsTest {
    PermissionsTest() {
    }

    static Method getMethod(Class<?> clazz, String method) {
        return Arrays.stream(clazz.getMethods()).filter(mth -> mth.getName().equals(method)).findFirst().get();
    }

    JexlPermissions permissions0() {
        String src = " org.apache.commons.jexl3.internal.introspection { PermissionsTest { InterNoJexl0 { } InterNoJexl1 { method(); } A0 { A0(); i0; } A1 { A1(); } A2 { } InterNoJexl5 { } } }";
        return JexlPermissions.parse((String[])new String[]{" org.apache.commons.jexl3.internal.introspection { PermissionsTest { InterNoJexl0 { } InterNoJexl1 { method(); } A0 { A0(); i0; } A1 { A1(); } A2 { } InterNoJexl5 { } } }"});
    }

    private void runTestPermissions(JexlPermissions p) throws Exception {
        Assertions.assertFalse((boolean)p.allow((Field)null));
        Assertions.assertFalse((boolean)p.allow((Package)null));
        Assertions.assertFalse((boolean)p.allow((Method)null));
        Assertions.assertFalse((boolean)p.allow((Constructor)null));
        Assertions.assertFalse((boolean)p.allow((Class)null));
        Assertions.assertFalse((boolean)p.allow(A2.class));
        Assertions.assertTrue((boolean)p.allow(A3.class));
        Assertions.assertTrue((boolean)p.allow(A5.class));
        Method mA = A.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA);
        Method mA0 = A0.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA0);
        Method mA1 = A1.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA1);
        Method mA2 = A2.class.getMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA2);
        Method mA3 = A2.class.getDeclaredMethod("method", new Class[0]);
        Assertions.assertNotNull((Object)mA3);
        Assertions.assertTrue((boolean)p.allow(mA));
        Assertions.assertFalse((boolean)p.allow(mA0));
        Assertions.assertFalse((boolean)p.allow(mA1));
        Assertions.assertFalse((boolean)p.allow(mA2));
        Assertions.assertFalse((boolean)p.allow(mA3));
        Field fA = A.class.getField("i");
        Assertions.assertNotNull((Object)fA);
        Assertions.assertTrue((boolean)p.allow(fA));
        Field fA0 = A0.class.getField("i0");
        Assertions.assertNotNull((Object)fA0);
        Assertions.assertFalse((boolean)p.allow(fA0));
        Field fA1 = A1.class.getDeclaredField("i1");
        Assertions.assertNotNull((Object)fA1);
        Assertions.assertFalse((boolean)p.allow(fA0));
        Constructor cA = A.class.getConstructor(new Class[0]);
        Assertions.assertNotNull(cA);
        Assertions.assertTrue((boolean)p.allow(cA));
        Constructor cA0 = A0.class.getConstructor(new Class[0]);
        Assertions.assertNotNull(cA0);
        Assertions.assertFalse((boolean)p.allow(cA0));
        Constructor cA3 = A3.class.getDeclaredConstructor(new Class[0]);
        Assertions.assertNotNull(cA3);
        Assertions.assertFalse((boolean)p.allow(cA3));
    }

    @Test
    void testGetPackageName() {
        String PKG = "org.apache.commons.jexl3.internal.introspection";
        String pkg = ClassTool.getPackageName(Outer.class);
        Assertions.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        pkg = ClassTool.getPackageName(Outer.Inner.class);
        Assertions.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        Outer[] oo = new Outer[]{};
        pkg = ClassTool.getPackageName(oo.getClass());
        Assertions.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        Outer.Inner[] ii = new Outer.Inner[]{};
        pkg = ClassTool.getPackageName(ii.getClass());
        Assertions.assertEquals((Object)"org.apache.commons.jexl3.internal.introspection", (Object)pkg);
        pkg = ClassTool.getPackageName(Process.class);
        Assertions.assertEquals((Object)"java.lang", (Object)pkg);
        pkg = ClassTool.getPackageName(Integer.TYPE);
        Assertions.assertEquals((Object)"java.lang", (Object)pkg);
    }

    @Test
    void testParsePermissions0a() throws Exception {
        String src = "java.lang { Runtime { exit(); exec(); } }\njava.net { URL {} }";
        Permissions p = (Permissions)JexlPermissions.parse((String[])new String[]{"java.lang { Runtime { exit(); exec(); } }\njava.net { URL {} }"});
        Map nojexlmap = p.getPackages();
        Assertions.assertNotNull((Object)nojexlmap);
        Permissions.NoJexlPackage njp = (Permissions.NoJexlPackage)nojexlmap.get("java.lang");
        Assertions.assertNotNull((Object)njp);
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assertions.assertNotNull((Object)exit);
        Assertions.assertFalse((boolean)p.allow(exit));
        Method exec = PermissionsTest.getMethod(Runtime.class, "exec");
        Assertions.assertNotNull((Object)exec);
        Assertions.assertFalse((boolean)p.allow(exec));
        Method avp = PermissionsTest.getMethod(Runtime.class, "availableProcessors");
        Assertions.assertNotNull((Object)avp);
        Assertions.assertTrue((boolean)p.allow(avp));
        Uberspect uber = new Uberspect(null, null, (JexlPermissions)p);
        Assertions.assertNull((Object)uber.getClassByName("java.net.URL"));
    }

    @Test
    void testParsePermissions0b() throws Exception {
        String src = "java.lang { -Runtime { exit(); } }";
        Permissions p = (Permissions)JexlPermissions.parse((String[])new String[]{"java.lang { -Runtime { exit(); } }"});
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assertions.assertNotNull((Object)exit);
        Assertions.assertFalse((boolean)p.allow(exit));
    }

    @Test
    void testParsePermissions0c() throws Exception {
        String src = "java.lang { +Runtime { availableProcessorCount(); } }";
        Permissions p = (Permissions)JexlPermissions.parse((String[])new String[]{"java.lang { +Runtime { availableProcessorCount(); } }"});
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assertions.assertNotNull((Object)exit);
        Assertions.assertFalse((boolean)p.allow(exit));
    }

    @Test
    void testParsePermissions0d() throws Exception {
        String src = "java.lang { +System { currentTimeMillis(); } }";
        JexlPermissions p = JexlPermissions.RESTRICTED.compose(new String[]{"java.lang { +System { currentTimeMillis(); } }"});
        Field in = System.class.getField("in");
        Assertions.assertNotNull((Object)in);
        Assertions.assertFalse((boolean)p.allow(in));
        Method ctm = PermissionsTest.getMethod(System.class, "currentTimeMillis");
        Assertions.assertNotNull((Object)ctm);
        Assertions.assertTrue((boolean)p.allow(ctm));
    }

    @Test
    void testParsePermissions0e() throws Exception {
        String src = "java.lang { +System { in; } }";
        JexlPermissions p = JexlPermissions.RESTRICTED.compose(new String[]{"java.lang { +System { in; } }"});
        Field in = System.class.getField("in");
        Assertions.assertNotNull((Object)in);
        Assertions.assertTrue((boolean)p.allow(in));
        Method ctm = PermissionsTest.getMethod(System.class, "currentTimeMillis");
        Assertions.assertNotNull((Object)ctm);
        Assertions.assertFalse((boolean)p.allow(ctm));
    }

    @Test
    void testParsePermissions0f() throws Exception {
        String src = "java.lang { +Class { getName(); getSimpleName(); } }";
        JexlPermissions p = JexlPermissions.RESTRICTED.compose(new String[]{"java.lang { +Class { getName(); getSimpleName(); } }"});
        Method getName = PermissionsTest.getMethod(Class.class, "getName");
        Assertions.assertNotNull((Object)getName);
        Assertions.assertTrue((boolean)p.allow(getName));
        Assertions.assertFalse((boolean)JexlPermissions.RESTRICTED.allow(getName));
        Method getSimpleName = PermissionsTest.getMethod(Class.class, "getSimpleName");
        Assertions.assertNotNull((Object)getSimpleName);
        Assertions.assertTrue((boolean)p.allow(getSimpleName));
        Assertions.assertFalse((boolean)JexlPermissions.RESTRICTED.allow(getSimpleName));
        Method getMethod = PermissionsTest.getMethod(Class.class, "getMethod");
        Assertions.assertNotNull((Object)getMethod);
        Assertions.assertFalse((boolean)p.allow(getMethod));
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assertions.assertNotNull((Object)exit);
        Assertions.assertFalse((boolean)p.allow(exit));
    }

    @Test
    void testParsePermissions0g() throws Exception {
        String src = "java.lang { +Class {  } }";
        JexlPermissions p = JexlPermissions.RESTRICTED.compose(new String[]{"java.lang { +Class {  } }"});
        Method getName = PermissionsTest.getMethod(Class.class, "getName");
        Assertions.assertNotNull((Object)getName);
        Assertions.assertTrue((boolean)p.allow(getName));
        Method getMethod = PermissionsTest.getMethod(Class.class, "getMethod");
        Assertions.assertNotNull((Object)getMethod);
        Assertions.assertTrue((boolean)p.allow(getMethod));
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assertions.assertNotNull((Object)exit);
        Assertions.assertFalse((boolean)p.allow(exit));
    }

    @Test
    void testParsePermissions1() {
        String[] src = new String[]{"java.lang.*", "java.math.*", "java.text.*", "java.util.*", "java.lang { Runtime {} }", "java.rmi {}", "java.io { File {} }", "java.nio { Path {} }", "org.apache.commons.jexl3.internal.introspection { PermissionsTest { #level 0\n Outer { #level 1\n Inner { #level 2\n callMeNot(); } } } }"};
        Permissions p = (Permissions)JexlPermissions.parse((String[])src);
        Map nojexlmap = p.getPackages();
        Assertions.assertNotNull((Object)nojexlmap);
        Set wildcards = p.getWildcards();
        Assertions.assertEquals((int)4, (int)wildcards.size());
        JexlEngine jexl = new JexlBuilder().permissions((JexlPermissions)p).safe(false).lexical(true).create();
        Method exit = PermissionsTest.getMethod(Runtime.class, "exit");
        Assertions.assertNotNull((Object)exit);
        Assertions.assertFalse((boolean)p.allow(exit));
        Method exec = PermissionsTest.getMethod(Runtime.class, "getRuntime");
        Assertions.assertNotNull((Object)exec);
        Assertions.assertFalse((boolean)p.allow(exec));
        Method callMeNot = PermissionsTest.getMethod(Outer.Inner.class, "callMeNot");
        Assertions.assertNotNull((Object)callMeNot);
        Assertions.assertFalse((boolean)p.allow(callMeNot));
        JexlScript script = jexl.createScript("o.callMeNot()", new String[]{"o"});
        Assertions.assertEquals((Object)"callMeNot", (Object)((JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> script.execute(null, new Object[]{new Outer.Inner()}))).getMethod());
        Method uncallable = PermissionsTest.getMethod(Invisible.class, "uncallable");
        Assertions.assertFalse((boolean)p.allow(uncallable));
        Package ip = Invisible.class.getPackage();
        Assertions.assertFalse((boolean)p.allow(ip));
        JexlScript script2 = jexl.createScript("o.uncallable()", new String[]{"o"});
        Assertions.assertEquals((Object)"uncallable", (Object)((JexlException.Method)Assertions.assertThrows(JexlException.Method.class, () -> script2.execute(null, new Object[]{new Invisible()}))).getMethod());
    }

    @Test
    void testParsePermissionsFailures() {
        String[] srcs;
        for (String src : srcs = new String[]{"java.lang.*.*", "java.math.*.", "java.text.*;", "java.lang {{ Runtime {} }", "java.rmi {}}", "java.io { Text File {} }", "java.io { File { m.x } }"}) {
            Assertions.assertThrows(IllegalStateException.class, () -> JexlPermissions.parse((String[])new String[]{src}));
        }
    }

    @Test
    void testPermissions0() throws Exception {
        this.runTestPermissions(this.permissions0());
    }

    @Test
    void testPermissions1() throws Exception {
        this.runTestPermissions((JexlPermissions)new JexlPermissions.Delegate(this.permissions0()){

            public String toString() {
                return "delegate:" + this.base.toString();
            }
        });
    }

    @Test
    void testPermissions2() throws Exception {
        this.runTestPermissions((JexlPermissions)new JexlPermissions.ClassPermissions(this.permissions0(), Collections.emptySet()));
    }

    @Test
    void testPrivateOverload1() throws Exception {
        String src = "parseDouble(\"PHM1\".substring(3)).intValue()";
        I33Arithmetic jexla = new I33Arithmetic(true);
        JexlEngine jexl = new JexlBuilder().safe(false).arithmetic((JexlArithmetic)jexla).create();
        JexlScript script = jexl.createScript("parseDouble(\"PHM1\".substring(3)).intValue()");
        Assertions.assertNotNull((Object)script);
        Object result = script.execute(null);
        Assertions.assertEquals((Object)1, (Object)result);
    }

    @Test
    void testProtectedOverride0() {
        Foo3 foo3 = new Foo3();
        JexlEngine jexl = new JexlBuilder().safe(false).create();
        Foo2 foo2 = new Foo2();
        JexlScript script = jexl.createScript("x.protectedMethod()", new String[]{"x"});
        Assertions.assertThrows(JexlException.class, () -> script.execute(null, new Object[]{foo2}), (String)"protectedMethod() is not public through superclass Foo2");
        Object r = script.execute(null, new Object[]{foo3});
        Assertions.assertEquals((Object)"foo3", (Object)r);
    }

    @Test
    void testProtectedOverride1() {
        LinkedList<String> a = new LinkedList<String>();
        a.add("aaa");
        a.add("bbb");
        String src = "a.clone()";
        JexlEngine jexl = new JexlBuilder().safe(true).create();
        JexlScript script = jexl.createScript("a.clone()");
        MapContext context = new MapContext();
        context.set("a", a);
        Object result = script.execute((JexlContext)context, new Object[]{a});
        Assertions.assertNotNull((Object)result);
    }

    @Test
    void testSecurePermissions() {
        Assertions.assertNotNull((Object)JexlTestCase.SECURE);
        List<Class> acs = Arrays.asList(Runtime.class, BigDecimal.class, SimpleDateFormat.class, Map.class);
        for (Class ac : acs) {
            Package p = ac.getPackage();
            Assertions.assertNotNull((Object)p, ac::getName);
            Assertions.assertTrue((boolean)JexlTestCase.SECURE.allow(p), ac::getName);
        }
        List<Class> nacs = Arrays.asList(ElementType.class, ClassDefinition.class, CallSite.class, BufferPoolMXBean.class, SoftReference.class, Method.class);
        for (Class nac : nacs) {
            Package p = nac.getPackage();
            Assertions.assertNotNull((Object)p, nac::getName);
            Assertions.assertFalse((boolean)JexlTestCase.SECURE.allow(p), nac::getName);
        }
    }

    @Test
    void testWildCardPackages() {
        HashSet<String> wildcards = new HashSet<String>(Arrays.asList("com.apache.*"));
        boolean found = Permissions.wildcardAllow(wildcards, (String)"com.apache.commons.jexl3");
        Assertions.assertTrue((boolean)found);
        found = Permissions.wildcardAllow(wildcards, (String)"com.google.spexl");
        Assertions.assertFalse((boolean)found);
    }

    public static class A2
    extends A {
        @Override
        public int method() {
            return 3;
        }
    }

    protected static class A3 {
        protected int i3;

        protected A3() {
        }

        int method() {
            return 4;
        }
    }

    public static class A5
    implements InterNoJexl5 {
        @Override
        public int method() {
            return 0;
        }
    }

    public static class A {
        public int i;

        public int method() {
            return 0;
        }
    }

    public static class A0
    extends A
    implements InterNoJexl0 {
        public int i0;

        @Override
        public int method() {
            return 1;
        }
    }

    public static class A1
    extends A
    implements InterNoJexl1 {
        private int i1;

        @Override
        public int method() {
            return 2;
        }
    }

    public static class Outer {

        public static class Inner {
            public void callMeNot() {
            }
        }
    }

    public class I33Arithmetic
    extends JexlArithmetic {
        public I33Arithmetic(boolean astrict) {
            super(astrict);
        }

        public double parseDouble(String s) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                return Double.NaN;
            }
        }
    }

    public static class Foo3
    extends Foo2 {
        @Override
        public String protectedMethod() {
            return "foo3";
        }

        @Override
        public String publicMethod() {
            return "foo3";
        }
    }

    protected static class Foo2 {
        protected Foo2() {
        }

        protected String protectedMethod() {
            return "foo2";
        }

        public String publicMethod() {
            return "foo2";
        }
    }

    public static interface InterNoJexl5 {
        public int method();
    }

    public static interface InterNoJexl1 {
        public int method();
    }

    public static interface InterNoJexl0 {
        public int method();
    }
}

