/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.set;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.functors.TruePredicate;
import org.apache.commons.collections4.set.AbstractSetTest;
import org.apache.commons.collections4.set.PredicatedSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PredicatedSetTest<E>
extends AbstractSetTest<E> {
    protected Predicate<E> truePredicate = TruePredicate.truePredicate();
    protected Predicate<E> testPredicate = String.class::isInstance;

    protected PredicatedSet<E> decorateSet(Set<E> set, Predicate<? super E> predicate) {
        return PredicatedSet.predicatedSet(set, predicate);
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public E[] getFullElements() {
        return new Object[]{"1", "3", "5", "7", "2", "4", "6"};
    }

    @Override
    protected int getIterationBehaviour() {
        return 1;
    }

    @Override
    public PredicatedSet<E> makeObject() {
        return this.decorateSet(new HashSet(), this.truePredicate);
    }

    protected PredicatedSet<E> makeTestSet() {
        return this.decorateSet(new HashSet(), this.testPredicate);
    }

    @Test
    public void testGetSet() {
        PredicatedSet<E> set = this.makeTestSet();
        Assertions.assertNotNull((Object)set.decorated(), (String)"returned set should not be null");
    }

    @Test
    public void testIllegalAdd() {
        PredicatedSet set = this.makeTestSet();
        Integer i = 3;
        Assertions.assertThrows(IllegalArgumentException.class, () -> set.add(i), (String)"Integer should fail string predicate.");
        Assertions.assertFalse((boolean)set.contains(i), (String)"Collection shouldn't contain illegal element");
    }

    @Test
    public void testIllegalAddAll() {
        PredicatedSet set = this.makeTestSet();
        HashSet<Object> elements = new HashSet<Object>();
        elements.add("one");
        elements.add("two");
        elements.add(3);
        elements.add("four");
        Assertions.assertThrows(IllegalArgumentException.class, () -> set.addAll(elements), (String)"Integer should fail string predicate.");
        Assertions.assertFalse((boolean)set.contains("one"), (String)"Set shouldn't contain illegal element");
        Assertions.assertFalse((boolean)set.contains("two"), (String)"Set shouldn't contain illegal element");
        Assertions.assertFalse((boolean)set.contains(3), (String)"Set shouldn't contain illegal element");
        Assertions.assertFalse((boolean)set.contains("four"), (String)"Set shouldn't contain illegal element");
    }
}

