/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections4.list.AbstractListTest;
import org.apache.commons.collections4.list.TreeList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TreeListTest<E>
extends AbstractListTest<E> {
    public static void benchmark(List<? super Integer> l) {
        int i;
        long startMillis = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            l.add((Integer)i);
        }
        System.out.print(System.currentTimeMillis() - startMillis + ";");
        startMillis = System.currentTimeMillis();
        for (i = 0; i < 200; ++i) {
            l.toArray();
        }
        System.out.print(System.currentTimeMillis() - startMillis + ";");
        startMillis = System.currentTimeMillis();
        for (i = 0; i < 100; ++i) {
            Iterator<? super Integer> it = l.iterator();
            while (it.hasNext()) {
                it.next();
            }
        }
        System.out.print(System.currentTimeMillis() - startMillis + ";");
        startMillis = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int j = (int)(Math.random() * 100000.0);
            l.add(j, (Integer)(-j));
        }
        System.out.print(System.currentTimeMillis() - startMillis + ";");
        startMillis = System.currentTimeMillis();
        for (i = 0; i < 50000; ++i) {
            int j = (int)(Math.random() * 110000.0);
            l.get(j);
        }
        System.out.print(System.currentTimeMillis() - startMillis + ";");
        startMillis = System.currentTimeMillis();
        for (i = 0; i < 200; ++i) {
            int j = (int)(Math.random() * 100000.0);
            l.indexOf(j);
        }
        System.out.print(System.currentTimeMillis() - startMillis + ";");
        startMillis = System.currentTimeMillis();
        for (i = 0; i < 10000; ++i) {
            int j = (int)(Math.random() * 100000.0);
            l.remove(j);
        }
        System.out.print(System.currentTimeMillis() - startMillis + ";");
    }

    @Override
    public TreeList<E> makeObject() {
        return new TreeList();
    }

    @Test
    public void testAddMultiple() {
        TreeList<String> l = this.makeObject();
        l.add("hugo");
        l.add("erna");
        l.add("daniel");
        l.add("andres");
        l.add("harald");
        l.add(0, null);
        Assertions.assertNull(l.get(0));
        Assertions.assertEquals((Object)"hugo", l.get(1));
        Assertions.assertEquals((Object)"erna", l.get(2));
        Assertions.assertEquals((Object)"daniel", l.get(3));
        Assertions.assertEquals((Object)"andres", l.get(4));
        Assertions.assertEquals((Object)"harald", l.get(5));
    }

    @Test
    public void testBug35258() {
        Integer objectToRemove = 3;
        TreeList treelist = new TreeList();
        treelist.add(0);
        treelist.add(1);
        treelist.add(2);
        treelist.add(3);
        treelist.add(4);
        treelist.remove(objectToRemove);
        ListIterator li = treelist.listIterator();
        Assertions.assertEquals((Integer)0, (Integer)((Integer)li.next()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)li.previous()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)li.next()));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)li.next()));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)li.previous()));
        Assertions.assertEquals((Integer)1, (Integer)((Integer)li.next()));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)li.next()));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)li.previous()));
        Assertions.assertEquals((Integer)2, (Integer)((Integer)li.next()));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)li.next()));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)li.previous()));
        Assertions.assertEquals((Integer)4, (Integer)((Integer)li.next()));
        Assertions.assertFalse((boolean)li.hasNext());
    }

    @Test
    public void testBugCollections447() {
        TreeList treeList = new TreeList();
        treeList.add("A");
        treeList.add("B");
        treeList.add("C");
        treeList.add("D");
        ListIterator li = treeList.listIterator();
        Assertions.assertEquals((Object)"A", li.next());
        Assertions.assertEquals((Object)"B", li.next());
        Assertions.assertEquals((Object)"B", li.previous());
        li.remove();
        Assertions.assertEquals((Object)"A", li.previous());
    }

    @Test
    public void testIndexOf() {
        TreeList<String> l = this.makeObject();
        l.add("0");
        l.add("1");
        l.add("2");
        l.add("3");
        l.add("4");
        l.add("5");
        l.add("6");
        Assertions.assertEquals((int)0, (int)l.indexOf("0"));
        Assertions.assertEquals((int)1, (int)l.indexOf("1"));
        Assertions.assertEquals((int)2, (int)l.indexOf("2"));
        Assertions.assertEquals((int)3, (int)l.indexOf("3"));
        Assertions.assertEquals((int)4, (int)l.indexOf("4"));
        Assertions.assertEquals((int)5, (int)l.indexOf("5"));
        Assertions.assertEquals((int)6, (int)l.indexOf("6"));
        l.set(1, "0");
        Assertions.assertEquals((int)0, (int)l.indexOf("0"));
        l.set(3, "3");
        Assertions.assertEquals((int)3, (int)l.indexOf("3"));
        l.set(2, "3");
        Assertions.assertEquals((int)2, (int)l.indexOf("3"));
        l.set(1, "3");
        Assertions.assertEquals((int)1, (int)l.indexOf("3"));
        l.set(0, "3");
        Assertions.assertEquals((int)0, (int)l.indexOf("3"));
    }

    @Test
    public void testInsertBefore() {
        TreeList<String> l = this.makeObject();
        l.add("erna");
        l.add(0, "hugo");
        Assertions.assertEquals((Object)"hugo", l.get(0));
        Assertions.assertEquals((Object)"erna", l.get(1));
    }

    @Test
    public void testIterationOrder() {
        for (int size = 1; size < 1000; ++size) {
            Integer val;
            ArrayList<Integer> other = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                other.add(i);
            }
            TreeList l = new TreeList(other);
            ListIterator it = l.listIterator();
            int i = 0;
            while (it.hasNext()) {
                val = (Integer)it.next();
                Assertions.assertEquals((int)i++, (int)val);
            }
            while (it.hasPrevious()) {
                val = (Integer)it.previous();
                Assertions.assertEquals((int)(--i), (int)val);
            }
        }
    }

    @Test
    public void testIterationOrderAfterAddAll() {
        int size = 1000;
        for (int i = 0; i < 100; ++i) {
            Integer val;
            ArrayList<Integer> other = new ArrayList<Integer>(1000);
            for (int j = i; j < 1000; ++j) {
                other.add(j);
            }
            TreeList l = new TreeList();
            for (int j = 0; j < i; ++j) {
                l.add((Object)j);
            }
            l.addAll(other);
            ListIterator it = l.listIterator();
            int cnt = 0;
            while (it.hasNext()) {
                val = (Integer)it.next();
                Assertions.assertEquals((int)cnt++, (int)val);
            }
            while (it.hasPrevious()) {
                val = (Integer)it.previous();
                Assertions.assertEquals((int)(--cnt), (int)val);
            }
        }
    }

    @Test
    public void testRemove() {
        TreeList<String> l = this.makeObject();
        l.add("hugo");
        l.add("erna");
        l.add("daniel");
        l.add("andres");
        l.add("harald");
        l.add(0, null);
        int i = 0;
        Assertions.assertNull(l.get(i++));
        Assertions.assertEquals((Object)"hugo", l.get(i++));
        Assertions.assertEquals((Object)"erna", l.get(i++));
        Assertions.assertEquals((Object)"daniel", l.get(i++));
        Assertions.assertEquals((Object)"andres", l.get(i++));
        Assertions.assertEquals((Object)"harald", l.get(i++));
        l.remove(0);
        i = 0;
        Assertions.assertEquals((Object)"hugo", l.get(i++));
        Assertions.assertEquals((Object)"erna", l.get(i++));
        Assertions.assertEquals((Object)"daniel", l.get(i++));
        Assertions.assertEquals((Object)"andres", l.get(i++));
        Assertions.assertEquals((Object)"harald", l.get(i++));
        i = 0;
        l.remove(1);
        Assertions.assertEquals((Object)"hugo", l.get(i++));
        Assertions.assertEquals((Object)"daniel", l.get(i++));
        Assertions.assertEquals((Object)"andres", l.get(i++));
        Assertions.assertEquals((Object)"harald", l.get(i++));
        i = 0;
        l.remove(2);
        Assertions.assertEquals((Object)"hugo", l.get(i++));
        Assertions.assertEquals((Object)"daniel", l.get(i++));
        Assertions.assertEquals((Object)"harald", l.get(i++));
    }
}

