/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.commons.collections4.bloomfilter.BloomFilter;
import org.apache.commons.collections4.bloomfilter.BloomFilterExtractor;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IncrementingHasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.LayerManager;
import org.apache.commons.collections4.bloomfilter.Shape;
import org.apache.commons.collections4.bloomfilter.SimpleBloomFilter;
import org.apache.commons.collections4.bloomfilter.TestingHashers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class LayerManagerTest {
    private final Shape shape = Shape.fromKM((int)17, (int)72);

    @ParameterizedTest
    @ValueSource(ints={4, 10, 2, 1})
    public void testAdvanceOnCount(int breakAt) {
        Predicate underTest = LayerManager.ExtendCheck.advanceOnCount((int)breakAt);
        LayerManager layerManager = this.testingBuilder().get();
        for (int i = 0; i < breakAt - 1; ++i) {
            Assertions.assertFalse((boolean)underTest.test(layerManager), (String)("at " + i));
            ((SimpleBloomFilter)layerManager.getTarget()).merge(TestingHashers.FROM1);
        }
        Assertions.assertTrue((boolean)underTest.test(layerManager));
    }

    @Test
    public void testAdvanceOnCountInvalidArguments() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> LayerManager.ExtendCheck.advanceOnCount((int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LayerManager.ExtendCheck.advanceOnCount((int)-1));
    }

    @Test
    public void testAdvanceOnPopulated() {
        Predicate underTest = LayerManager.ExtendCheck.advanceOnPopulated();
        LayerManager layerManager = this.testingBuilder().get();
        Assertions.assertFalse((boolean)underTest.test(layerManager));
        ((SimpleBloomFilter)layerManager.getTarget()).merge(TestingHashers.FROM1);
        Assertions.assertTrue((boolean)underTest.test(layerManager));
    }

    @Test
    public void testAdvanceOnSaturation() {
        double maxN = this.shape.estimateMaxN();
        int hashStart = 0;
        Predicate underTest = LayerManager.ExtendCheck.advanceOnSaturation((double)maxN);
        LayerManager layerManager = this.testingBuilder().get();
        while (((SimpleBloomFilter)layerManager.getTarget()).getShape().estimateN(((SimpleBloomFilter)layerManager.getTarget()).cardinality()) < maxN) {
            Assertions.assertFalse((boolean)underTest.test(layerManager));
            ((SimpleBloomFilter)layerManager.getTarget()).merge((Hasher)new IncrementingHasher(hashStart, this.shape.getNumberOfHashFunctions()));
            hashStart += this.shape.getNumberOfHashFunctions();
        }
        Assertions.assertTrue((boolean)underTest.test(layerManager));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LayerManager.ExtendCheck.advanceOnSaturation((double)0.0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LayerManager.ExtendCheck.advanceOnSaturation((double)-1.0));
    }

    @Test
    public void testBuilder() {
        LayerManager.Builder underTest = LayerManager.builder();
        NullPointerException npe = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> ((LayerManager.Builder)underTest).get());
        Assertions.assertTrue((boolean)npe.getMessage().contains("filterSupplier"));
        underTest.setSupplier(() -> null).setCleanup(null);
        npe = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> ((LayerManager.Builder)underTest).get());
        Assertions.assertTrue((boolean)npe.getMessage().contains("filterCleanup"));
        underTest.setCleanup(x -> {}).setExtendCheck(null);
        npe = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> ((LayerManager.Builder)underTest).get());
        Assertions.assertTrue((boolean)npe.getMessage().contains("extendCheck"));
        npe = (NullPointerException)Assertions.assertThrows(NullPointerException.class, () -> LayerManager.builder().setSupplier(() -> null).get());
        Assertions.assertTrue((boolean)npe.getMessage().contains("filterSupplier.get() returned null."));
    }

    @Test
    public void testClear() {
        LayerManager underTest = LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.shape)).get();
        ((SimpleBloomFilter)underTest.getTarget()).merge(TestingHashers.randomHasher());
        underTest.next();
        ((SimpleBloomFilter)underTest.getTarget()).merge(TestingHashers.randomHasher());
        underTest.next();
        ((SimpleBloomFilter)underTest.getTarget()).merge(TestingHashers.randomHasher());
        Assertions.assertEquals((int)3, (int)underTest.getDepth());
        underTest.clear();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        Assertions.assertEquals((int)0, (int)((SimpleBloomFilter)underTest.getTarget()).cardinality());
    }

    @Test
    public void testCopy() {
        LayerManager underTest = LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.shape)).get();
        ((SimpleBloomFilter)underTest.getTarget()).merge(TestingHashers.randomHasher());
        underTest.next();
        ((SimpleBloomFilter)underTest.getTarget()).merge(TestingHashers.randomHasher());
        underTest.next();
        ((SimpleBloomFilter)underTest.getTarget()).merge(TestingHashers.randomHasher());
        Assertions.assertEquals((int)3, (int)underTest.getDepth());
        LayerManager copy = underTest.copy();
        Assertions.assertNotSame((Object)underTest, (Object)copy);
        Assertions.assertNotEquals((Object)underTest, (Object)copy);
        Assertions.assertEquals((int)underTest.getDepth(), (int)copy.getDepth());
        Assertions.assertTrue((boolean)underTest.processBloomFilterPair((BloomFilterExtractor)copy, (x, y) -> Arrays.equals(x.asBitMapArray(), y.asBitMapArray())));
    }

    @Test
    public void testForEachBloomFilter() {
        LayerManager underTest = LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.shape)).setExtendCheck(LayerManager.ExtendCheck.advanceOnPopulated()).get();
        ArrayList<SimpleBloomFilter> lst = new ArrayList<SimpleBloomFilter>();
        for (int i = 0; i < 10; ++i) {
            SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
            bf.merge(TestingHashers.randomHasher());
            lst.add(bf);
            ((SimpleBloomFilter)underTest.getTarget()).merge((BloomFilter)bf);
        }
        ArrayList lst2 = new ArrayList();
        underTest.processBloomFilters(lst2::add);
        Assertions.assertEquals((int)10, (int)lst.size());
        Assertions.assertEquals((int)10, (int)lst2.size());
        for (int i = 0; i < lst.size(); ++i) {
            Assertions.assertArrayEquals((long[])((SimpleBloomFilter)lst.get(i)).asBitMapArray(), (long[])((BloomFilter)lst2.get(i)).asBitMapArray());
        }
    }

    @Test
    public void testGet() {
        SimpleBloomFilter f = new SimpleBloomFilter(this.shape);
        LayerManager underTest = LayerManager.builder().setSupplier(() -> f).get();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        Assertions.assertSame((Object)f, (Object)underTest.get(0));
        Assertions.assertThrows(NoSuchElementException.class, () -> underTest.get(-1));
        Assertions.assertThrows(NoSuchElementException.class, () -> underTest.get(1));
    }

    private LayerManager.Builder<SimpleBloomFilter> testingBuilder() {
        return LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.shape));
    }

    @Test
    public void testNeverAdvance() {
        Predicate underTest = LayerManager.ExtendCheck.neverAdvance();
        LayerManager layerManager = this.testingBuilder().get();
        Assertions.assertFalse((boolean)underTest.test(layerManager));
        for (int i = 0; i < 10; ++i) {
            ((SimpleBloomFilter)layerManager.getTarget()).merge(TestingHashers.randomHasher());
            Assertions.assertFalse((boolean)underTest.test(layerManager));
        }
    }

    @Test
    public void testNextAndGetDepth() {
        LayerManager underTest = LayerManager.builder().setSupplier(() -> new SimpleBloomFilter(this.shape)).get();
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        ((SimpleBloomFilter)underTest.getTarget()).merge(TestingHashers.randomHasher());
        Assertions.assertEquals((int)1, (int)underTest.getDepth());
        underTest.next();
        Assertions.assertEquals((int)2, (int)underTest.getDepth());
    }

    @Test
    public void testNoCleanup() {
        Consumer underTest = LayerManager.Cleanup.noCleanup();
        LinkedList<SimpleBloomFilter> list = new LinkedList<SimpleBloomFilter>();
        for (int i = 0; i < 20; ++i) {
            Assertions.assertEquals((int)i, (int)list.size());
            list.add(new SimpleBloomFilter(this.shape));
            underTest.accept(list);
        }
    }

    @ParameterizedTest
    @ValueSource(ints={5, 100, 2, 1})
    public void testOnMaxSize(int maxSize) {
        int i;
        Consumer underTest = LayerManager.Cleanup.onMaxSize((int)maxSize);
        LinkedList<SimpleBloomFilter> list = new LinkedList<SimpleBloomFilter>();
        for (i = 0; i < maxSize; ++i) {
            Assertions.assertEquals((int)i, (int)list.size());
            list.add(new SimpleBloomFilter(this.shape));
            underTest.accept(list);
        }
        Assertions.assertEquals((int)maxSize, (int)list.size());
        for (i = 0; i < maxSize; ++i) {
            list.add(new SimpleBloomFilter(this.shape));
            underTest.accept(list);
            Assertions.assertEquals((int)maxSize, (int)list.size());
        }
    }

    @Test
    public void testOnMaxSizeIllegalValues() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> LayerManager.Cleanup.onMaxSize((int)0));
        Assertions.assertThrows(IllegalArgumentException.class, () -> LayerManager.Cleanup.onMaxSize((int)-1));
    }

    @Test
    public void testRemoveEmptyTarget() {
        Consumer underTest = LayerManager.Cleanup.removeEmptyTarget();
        LinkedList<SimpleBloomFilter> list = new LinkedList<SimpleBloomFilter>();
        SimpleBloomFilter bf = new SimpleBloomFilter(this.shape);
        list.add(bf);
        Assertions.assertEquals((Object)bf, list.get(0));
        underTest.accept(list);
        Assertions.assertTrue((boolean)list.isEmpty());
        bf.merge(IndexExtractor.fromIndexArray((int[])new int[]{1}));
        list.add(bf);
        Assertions.assertEquals((Object)bf, list.get(0));
        underTest.accept(list);
        Assertions.assertEquals((Object)bf, list.get(0));
        list.clear();
        list.add(new SimpleBloomFilter(this.shape));
        list.add(bf);
        Assertions.assertEquals((int)2, (int)list.size());
        underTest.accept(list);
        Assertions.assertEquals((int)2, (int)list.size());
        list.clear();
        list.add(bf);
        list.add(new SimpleBloomFilter(this.shape));
        list.add(new SimpleBloomFilter(this.shape));
        Assertions.assertEquals((int)3, (int)list.size());
        underTest.accept(list);
        Assertions.assertEquals((int)2, (int)list.size());
        Assertions.assertEquals((Object)bf, list.get(0));
    }

    @Test
    public void testTarget() {
        boolean[] extendCheckCalled = new boolean[]{false};
        boolean[] cleanupCalled = new boolean[]{false};
        int[] supplierCount = new int[]{0};
        LayerManager underTest = LayerManager.builder().setSupplier(() -> {
            supplierCount[0] = supplierCount[0] + 1;
            return new SimpleBloomFilter(this.shape);
        }).setExtendCheck(lm -> {
            extendCheckCalled[0] = true;
            return true;
        }).setCleanup(ll -> {
            cleanupCalled[0] = true;
        }).get();
        Assertions.assertFalse((boolean)extendCheckCalled[0]);
        Assertions.assertFalse((boolean)cleanupCalled[0]);
        Assertions.assertEquals((int)1, (int)supplierCount[0]);
        underTest.getTarget();
        Assertions.assertTrue((boolean)extendCheckCalled[0]);
        Assertions.assertTrue((boolean)cleanupCalled[0]);
        Assertions.assertEquals((int)2, (int)supplierCount[0]);
    }
}

