/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bidimap;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.BulkTest;
import org.apache.commons.collections4.IterableMap;
import org.apache.commons.collections4.MapIterator;
import org.apache.commons.collections4.iterators.AbstractMapIteratorTest;
import org.apache.commons.collections4.map.AbstractIterableMapTest;
import org.apache.commons.collections4.map.AbstractMapTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

public abstract class AbstractBidiMapTest<K, V>
extends AbstractIterableMapTest<K, V> {
    public BulkTest bulkTestBidiMapIterator() {
        return new TestBidiMapIterator();
    }

    public BulkTest bulkTestInverseMap() {
        return new TestInverseBidiMap(this);
    }

    @Override
    public BulkTest bulkTestMapEntrySet() {
        return new TestBidiMapEntrySet();
    }

    private void doTestGetKey(BidiMap<?, ?> map, Object key, Object value) {
        Assertions.assertEquals((Object)value, (Object)map.get(key), (String)"Value not found for key.");
        Assertions.assertEquals((Object)key, (Object)map.getKey(value), (String)"Key not found for value.");
    }

    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public BidiMap<K, V> getMap() {
        return (BidiMap)super.getMap();
    }

    @Override
    public boolean isAllowDuplicateValues() {
        return false;
    }

    @Override
    public BidiMap<K, V> makeFullMap() {
        return (BidiMap)super.makeFullMap();
    }

    @Override
    public abstract BidiMap<K, V> makeObject();

    private <T> void modifyEntrySet(BidiMap<?, T> map) {
        Map.Entry entry = (Map.Entry)map.entrySet().iterator().next();
        Object key = entry.getKey();
        Object oldValue = entry.getValue();
        String newValue = "newValue";
        entry.setValue(newValue);
        Assertions.assertEquals((Object)newValue, (Object)map.get(key), (String)"Modifying entrySet did not affect underlying Map.");
        Assertions.assertNull((Object)map.getKey(oldValue), (String)"Modifying entrySet did not affect inverse Map.");
    }

    private void remove(BidiMap<?, ?> map, Object key) {
        Object value = map.remove(key);
        Assertions.assertFalse((boolean)map.containsKey(key), (String)"Key was not removed.");
        Assertions.assertNull((Object)map.getKey(value), (String)"Value was not removed.");
    }

    private void removeByEntrySet(BidiMap<?, ?> map, Object key, Object value) {
        HashMap<Object, Object> temp = new HashMap<Object, Object>();
        temp.put(key, value);
        map.entrySet().remove(temp.entrySet().iterator().next());
        Assertions.assertFalse((boolean)map.containsKey(key), (String)"Key was not removed.");
        Assertions.assertFalse((boolean)map.containsValue(value), (String)"Value was not removed.");
        Assertions.assertFalse((boolean)map.inverseBidiMap().containsValue(key), (String)"Key was not removed from inverse map.");
        Assertions.assertFalse((boolean)map.inverseBidiMap().containsKey(value), (String)"Value was not removed from inverse map.");
    }

    private void removeByKeySet(BidiMap<?, ?> map, Object key, Object value) {
        map.remove(key);
        Assertions.assertFalse((boolean)map.containsKey(key), (String)"Key was not removed.");
        Assertions.assertFalse((boolean)map.containsValue(value), (String)"Value was not removed.");
        Assertions.assertFalse((boolean)map.inverseBidiMap().containsValue(key), (String)"Key was not removed from inverse map.");
        Assertions.assertFalse((boolean)map.inverseBidiMap().containsKey(value), (String)"Value was not removed from inverse map.");
    }

    private void removeValue(BidiMap<?, ?> map, Object value) {
        Object key = map.removeValue(value);
        Assertions.assertFalse((boolean)map.containsKey(key), (String)"Key was not removed.");
        Assertions.assertNull((Object)map.getKey(value), (String)"Value was not removed.");
    }

    @Test
    public void testBidiClear() {
        if (!this.isRemoveSupported()) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.makeFullMap().clear());
            return;
        }
        BidiMap map = this.makeFullMap();
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"Map was not cleared.");
        Assertions.assertTrue((boolean)map.inverseBidiMap().isEmpty(), (String)"Inverse map was not cleared.");
        map = this.makeFullMap().inverseBidiMap();
        map.clear();
        Assertions.assertTrue((boolean)map.isEmpty(), (String)"Map was not cleared.");
        Assertions.assertTrue((boolean)map.inverseBidiMap().isEmpty(), (String)"Inverse map was not cleared.");
    }

    @Test
    public void testBidiGetKey() {
        this.doTestGetKey(this.makeFullMap(), this.getSampleKeys()[0], this.getSampleValues()[0]);
    }

    @Test
    public void testBidiGetKeyInverse() {
        this.doTestGetKey(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0], this.getSampleKeys()[0]);
    }

    @Test
    public void testBidiInverse() {
        BidiMap<K, V> map = this.makeFullMap();
        BidiMap inverseMap = map.inverseBidiMap();
        Assertions.assertSame(map, (Object)inverseMap.inverseBidiMap(), (String)"Inverse of inverse is not equal to original.");
        Assertions.assertEquals(this.getSampleKeys()[0], (Object)inverseMap.get(this.getSampleValues()[0]), (String)"Value not found for key.");
        Assertions.assertEquals(this.getSampleValues()[0], (Object)inverseMap.getKey(this.getSampleKeys()[0]), (String)"Key not found for value.");
    }

    @Test
    public void testBidiKeySetValuesOrder() {
        Assumptions.assumeFalse(((this.getIterationBehaviour() & 1) != 0 ? 1 : 0) != 0);
        this.resetFull();
        Iterator keys = ((IterableMap)this.map).keySet().iterator();
        Iterator values = ((IterableMap)this.map).values().iterator();
        while (keys.hasNext() && values.hasNext()) {
            Object key = keys.next();
            Object value = values.next();
            Assertions.assertSame((Object)((IterableMap)this.map).get(key), value);
        }
        Assertions.assertFalse((boolean)keys.hasNext());
        Assertions.assertFalse((boolean)values.hasNext());
    }

    @Test
    public void testBidiMapIteratorSet() {
        Object newValue1 = this.getOtherValues()[0];
        Object newValue2 = this.getOtherValues()[1];
        this.resetFull();
        BidiMap<K, V> bidi = this.getMap();
        MapIterator it = bidi.mapIterator();
        Assertions.assertTrue((boolean)it.hasNext());
        Object key1 = it.next();
        if (!this.isSetValueSupported()) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> it.setValue(newValue1));
            return;
        }
        it.setValue(newValue1);
        this.confirmed.put(key1, newValue1);
        Assertions.assertSame((Object)key1, (Object)it.getKey());
        Assertions.assertSame(newValue1, (Object)it.getValue());
        Assertions.assertTrue((boolean)bidi.containsKey(key1));
        Assertions.assertTrue((boolean)bidi.containsValue(newValue1));
        Assertions.assertEquals(newValue1, (Object)bidi.get(key1));
        this.verify();
        it.setValue(newValue1);
        this.confirmed.put(key1, newValue1);
        Assertions.assertSame((Object)key1, (Object)it.getKey());
        Assertions.assertSame(newValue1, (Object)it.getValue());
        Assertions.assertTrue((boolean)bidi.containsKey(key1));
        Assertions.assertTrue((boolean)bidi.containsValue(newValue1));
        Assertions.assertEquals(newValue1, (Object)bidi.get(key1));
        this.verify();
        Object key2 = it.next();
        it.setValue(newValue2);
        this.confirmed.put(key2, newValue2);
        Assertions.assertSame((Object)key2, (Object)it.getKey());
        Assertions.assertSame(newValue2, (Object)it.getValue());
        Assertions.assertTrue((boolean)bidi.containsKey(key2));
        Assertions.assertTrue((boolean)bidi.containsValue(newValue2));
        Assertions.assertEquals(newValue2, (Object)bidi.get(key2));
        this.verify();
        Assertions.assertThrows(IllegalArgumentException.class, () -> it.setValue(newValue1));
    }

    @Test
    public void testBidiModifyEntrySet() {
        if (!this.isSetValueSupported()) {
            return;
        }
        this.modifyEntrySet(this.makeFullMap());
        this.modifyEntrySet(this.makeFullMap().inverseBidiMap());
    }

    @Test
    public void testBidiPut() {
        if (!this.isPutAddSupported() || !this.isPutChangeSupported()) {
            return;
        }
        BidiMap<K, V> map = this.makeObject();
        BidiMap inverse = map.inverseBidiMap();
        Assertions.assertEquals((int)0, (int)map.size());
        Assertions.assertEquals((int)map.size(), (int)inverse.size());
        map.put((Object)"A", (Object)"B");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)map.size(), (int)inverse.size());
        Assertions.assertEquals((Object)"B", (Object)map.get((Object)"A"));
        Assertions.assertEquals((Object)"A", (Object)inverse.get((Object)"B"));
        map.put((Object)"A", (Object)"C");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)map.size(), (int)inverse.size());
        Assertions.assertEquals((Object)"C", (Object)map.get((Object)"A"));
        Assertions.assertEquals((Object)"A", (Object)inverse.get((Object)"C"));
        map.put((Object)"B", (Object)"C");
        Assertions.assertEquals((int)1, (int)map.size());
        Assertions.assertEquals((int)map.size(), (int)inverse.size());
        Assertions.assertEquals((Object)"C", (Object)map.get((Object)"B"));
        Assertions.assertEquals((Object)"B", (Object)inverse.get((Object)"C"));
        map.put((Object)"E", (Object)"F");
        Assertions.assertEquals((int)2, (int)map.size());
        Assertions.assertEquals((int)map.size(), (int)inverse.size());
        Assertions.assertEquals((Object)"F", (Object)map.get((Object)"E"));
        Assertions.assertEquals((Object)"E", (Object)inverse.get((Object)"F"));
    }

    @Test
    public void testBidiRemove() {
        if (!this.isRemoveSupported()) {
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.makeFullMap().remove(this.getSampleKeys()[0]));
            Assertions.assertThrows(UnsupportedOperationException.class, () -> this.makeFullMap().removeValue(this.getSampleValues()[0]));
            return;
        }
        this.remove(this.makeFullMap(), this.getSampleKeys()[0]);
        this.remove(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0]);
        this.removeValue(this.makeFullMap(), this.getSampleValues()[0]);
        this.removeValue(this.makeFullMap().inverseBidiMap(), this.getSampleKeys()[0]);
        Assertions.assertNull((Object)this.makeFullMap().removeValue((Object)"NotPresent"));
    }

    @Test
    public void testBidiRemoveByEntrySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.removeByEntrySet(this.makeFullMap(), this.getSampleKeys()[0], this.getSampleValues()[0]);
        this.removeByEntrySet(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0], this.getSampleKeys()[0]);
    }

    @Test
    public void testBidiRemoveByKeySet() {
        if (!this.isRemoveSupported()) {
            return;
        }
        this.removeByKeySet(this.makeFullMap(), this.getSampleKeys()[0], this.getSampleValues()[0]);
        this.removeByKeySet(this.makeFullMap().inverseBidiMap(), this.getSampleValues()[0], this.getSampleKeys()[0]);
    }

    @Override
    public void verify() {
        this.verifyInverse();
        super.verify();
    }

    public void verifyInverse() {
        Assertions.assertEquals((int)((IterableMap)this.map).size(), (int)((BidiMap)this.map).inverseBidiMap().size());
        HashMap map1 = new HashMap(this.map);
        HashMap map2 = new HashMap(((BidiMap)this.map).inverseBidiMap());
        Set keys1 = map1.keySet();
        Set keys2 = map2.keySet();
        Collection values1 = map1.values();
        Collection values2 = map2.values();
        Assertions.assertTrue((boolean)keys1.containsAll(values2));
        Assertions.assertTrue((boolean)values2.containsAll(keys1));
        Assertions.assertTrue((boolean)values1.containsAll(keys2));
        Assertions.assertTrue((boolean)keys2.containsAll(values1));
    }

    public class TestBidiMapIterator
    extends AbstractMapIteratorTest<K, V> {
        @Override
        public V[] addSetValues() {
            return AbstractBidiMapTest.this.getNewSampleValues();
        }

        @Override
        public Map<K, V> getConfirmedMap() {
            return AbstractBidiMapTest.this.getConfirmed();
        }

        @Override
        public BidiMap<K, V> getMap() {
            return AbstractBidiMapTest.this.getMap();
        }

        @Override
        public MapIterator<K, V> makeEmptyIterator() {
            AbstractBidiMapTest.this.resetEmpty();
            return AbstractBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public MapIterator<K, V> makeObject() {
            AbstractBidiMapTest.this.resetFull();
            return AbstractBidiMapTest.this.getMap().mapIterator();
        }

        @Override
        public boolean supportsRemove() {
            return AbstractBidiMapTest.this.isRemoveSupported();
        }

        @Override
        public boolean supportsSetValue() {
            return AbstractBidiMapTest.this.isSetValueSupported();
        }

        @Override
        public void verify() {
            super.verify();
            AbstractBidiMapTest.this.verify();
        }
    }

    public class TestInverseBidiMap
    extends AbstractBidiMapTest<V, K> {
        final AbstractBidiMapTest<K, V> main;

        public TestInverseBidiMap(AbstractBidiMapTest<K, V> main) {
            this.main = main;
        }

        @Override
        public String getCompatibilityVersion() {
            return this.main.getCompatibilityVersion();
        }

        @Override
        protected int getIterationBehaviour() {
            return this.main.getIterationBehaviour();
        }

        @Override
        public V[] getSampleKeys() {
            return this.main.getSampleValues();
        }

        @Override
        public K[] getSampleValues() {
            return this.main.getSampleKeys();
        }

        @Override
        public boolean isAllowNullKey() {
            return this.main.isAllowNullKey();
        }

        @Override
        public boolean isAllowNullValue() {
            return this.main.isAllowNullValue();
        }

        @Override
        public boolean isAllowNullValueGet() {
            return this.main.isAllowNullValueGet();
        }

        @Override
        public boolean isAllowNullValuePut() {
            return this.main.isAllowNullValuePut();
        }

        @Override
        public boolean isPutAddSupported() {
            return this.main.isPutAddSupported();
        }

        @Override
        public boolean isPutChangeSupported() {
            return this.main.isPutChangeSupported();
        }

        @Override
        public boolean isRemoveSupported() {
            return this.main.isRemoveSupported();
        }

        @Override
        public boolean isSetValueSupported() {
            return this.main.isSetValueSupported();
        }

        @Override
        public BidiMap<V, K> makeFullMap() {
            return this.main.makeFullMap().inverseBidiMap();
        }

        @Override
        public BidiMap<V, K> makeObject() {
            return this.main.makeObject().inverseBidiMap();
        }
    }

    public class TestBidiMapEntrySet
    extends AbstractMapTest.TestMapEntrySet {
        public TestBidiMapEntrySet() {
            super(AbstractBidiMapTest.this);
        }

        @Test
        public void testMapEntrySetIteratorEntrySetValueCrossCheck() {
            Object key1 = AbstractBidiMapTest.this.getSampleKeys()[0];
            Object key2 = AbstractBidiMapTest.this.getSampleKeys()[1];
            Object newValue1 = AbstractBidiMapTest.this.getNewSampleValues()[0];
            Object newValue2 = AbstractBidiMapTest.this.getNewSampleValues()[1];
            this.resetFull();
            Iterator it = this.getCollection().iterator();
            Map.Entry entry1 = this.getEntry(it, key1);
            it = this.getCollection().iterator();
            Map.Entry entry2 = this.getEntry(it, key2);
            Iterator itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed1 = this.getEntry(itConfirmed, key1);
            itConfirmed = this.getConfirmed().iterator();
            Map.Entry entryConfirmed2 = this.getEntry(itConfirmed, key2);
            this.verify();
            if (!AbstractBidiMapTest.this.isSetValueSupported()) {
                Assertions.assertThrows(UnsupportedOperationException.class, () -> entry1.setValue(newValue1));
                return;
            }
            entry1.setValue(newValue1);
            entryConfirmed1.setValue(newValue1);
            entry2.setValue(newValue2);
            entryConfirmed2.setValue(newValue2);
            try {
                entry2.setValue(newValue1);
            }
            catch (IllegalArgumentException ex) {
                return;
            }
            entryConfirmed2.setValue(newValue1);
            AbstractBidiMapTest.this.getConfirmed().remove(key1);
            Assertions.assertEquals(newValue1, entry2.getValue());
            Assertions.assertTrue((boolean)AbstractBidiMapTest.this.getMap().containsKey(entry2.getKey()));
            Assertions.assertTrue((boolean)AbstractBidiMapTest.this.getMap().containsValue(newValue1));
            Assertions.assertEquals(newValue1, (Object)AbstractBidiMapTest.this.getMap().get(entry2.getKey()));
            Assertions.assertFalse((boolean)AbstractBidiMapTest.this.getMap().containsKey(key1));
            Assertions.assertFalse((boolean)AbstractBidiMapTest.this.getMap().containsValue(newValue2));
            this.verify();
            it.next();
            if (this.isRemoveSupported()) {
                it.remove();
            }
        }
    }
}

