/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4;

import java.util.EmptyStackException;
import org.apache.commons.collections4.AbstractArrayListTest;
import org.apache.commons.collections4.ArrayStack;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ArrayStackTest<E>
extends AbstractArrayListTest<E> {
    @Override
    public String getCompatibilityVersion() {
        return "4";
    }

    @Override
    public ArrayStack<E> makeObject() {
        return new ArrayStack();
    }

    @Test
    public void testNewStack() {
        ArrayStack stack = this.makeObject();
        Assertions.assertTrue((boolean)stack.empty(), (String)"New stack is empty");
        Assertions.assertEquals((int)0, (int)stack.size(), (String)"New stack has size zero");
        Assertions.assertThrows(EmptyStackException.class, () -> stack.peek());
        Assertions.assertThrows(EmptyStackException.class, () -> stack.pop());
    }

    @Test
    public void testPushPeekPop() {
        ArrayStack<E> stack = this.makeObject();
        stack.push((Object)"First Item");
        Assertions.assertFalse((boolean)stack.empty(), (String)"Stack is not empty");
        Assertions.assertEquals((int)1, (int)stack.size(), (String)"Stack size is one");
        Assertions.assertEquals((Object)"First Item", (Object)stack.peek(), (String)"Top item is 'First Item'");
        Assertions.assertEquals((int)1, (int)stack.size(), (String)"Stack size is one");
        stack.push((Object)"Second Item");
        Assertions.assertEquals((int)2, (int)stack.size(), (String)"Stack size is two");
        Assertions.assertEquals((Object)"Second Item", (Object)stack.peek(), (String)"Top item is 'Second Item'");
        Assertions.assertEquals((int)2, (int)stack.size(), (String)"Stack size is two");
        Assertions.assertEquals((Object)"Second Item", (Object)stack.pop(), (String)"Popped item is 'Second Item'");
        Assertions.assertEquals((Object)"First Item", (Object)stack.peek(), (String)"Top item is 'First Item'");
        Assertions.assertEquals((int)1, (int)stack.size(), (String)"Stack size is one");
        Assertions.assertEquals((Object)"First Item", (Object)stack.pop(), (String)"Popped item is 'First Item'");
        Assertions.assertEquals((int)0, (int)stack.size(), (String)"Stack size is zero");
    }

    @Override
    @Test
    public void testSearch() {
        ArrayStack<E> stack = this.makeObject();
        stack.push((Object)"First Item");
        stack.push((Object)"Second Item");
        Assertions.assertEquals((int)1, (int)stack.search((Object)"Second Item"), (String)"Top item is 'Second Item'");
        Assertions.assertEquals((int)2, (int)stack.search((Object)"First Item"), (String)"Next Item is 'First Item'");
        Assertions.assertEquals((int)-1, (int)stack.search((Object)"Missing Item"), (String)"Cannot find 'Missing Item'");
    }
}

