/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeAndComment;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeFormatter$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodeGenerator$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.codegen.GeneratedClass;
import org.apache.spark.sql.execution.columnar.CelebornBatchBuilder;
import org.apache.spark.sql.execution.columnar.CelebornBooleanCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornByteCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornCompactDecimalCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornCompactMiniDecimalCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornDecimalCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornDoubleCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornFloatCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornIntCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornLongCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornShortCodeGenColumnBuilder;
import org.apache.spark.sql.execution.columnar.CelebornStringCodeGenColumnBuilder;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001e3Aa\u0002\u0005\u0001+!)A\u0004\u0001C\u0001;!9\u0001\u0005\u0001b\u0001\n\u0013\t\u0003B\u0002\u0015\u0001A\u0003%!\u0005C\u0003*\u0001\u0011\u0005!\u0006C\u0003<\u0001\u0011\u0005A\bC\u0003K\u0001\u0011\u00051JA\u0011DK2,'m\u001c:o\u0007>dW/\u001c8be\n\u000bGo\u00195D_\u0012,w)\u001a8Ck&dGM\u0003\u0002\n\u0015\u0005A1m\u001c7v[:\f'O\u0003\u0002\f\u0019\u0005IQ\r_3dkRLwN\u001c\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f!\ty\u0002!D\u0001\t\u0003\u0019awnZ4feV\t!\u0005\u0005\u0002$M5\tAE\u0003\u0002&%\u0005)1\u000f\u001c45U&\u0011q\u0005\n\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sA\u000511M]3bi\u0016$2a\u000b\u00187!\tyB&\u0003\u0002.\u0011\t!2)\u001a7fE>\u0014hNQ1uG\"\u0014U/\u001b7eKJDQa\f\u0003A\u0002A\naa]2iK6\f\u0007CA\u00195\u001b\u0005\u0011$BA\u001a\r\u0003\u0015!\u0018\u0010]3t\u0013\t)$G\u0001\u0006TiJ,8\r\u001e+za\u0016DQa\u000e\u0003A\u0002a\n\u0011BY1uG\"\u001c\u0016N_3\u0011\u0005]I\u0014B\u0001\u001e\u0019\u0005\rIe\u000e^\u0001\bO\u0016t7i\u001c3f)\ri\u0004*\u0013\t\u0007/y\u0002\u0005\t\u0011!\n\u0005}B\"A\u0002+va2,G\u0007\u0005\u0002B\r6\t!I\u0003\u0002D\t\u00069Q.\u001e;bE2,'BA#\u0019\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u000f\n\u0013Qb\u0015;sS:<')^5mI\u0016\u0014\b\"B\u0018\u0006\u0001\u0004\u0001\u0004\"B\u001c\u0006\u0001\u0004A\u0014\u0001D4f]^\u0013\u0018\u000e^3D_\u0012,GC\u0001'X!\tiEK\u0004\u0002O%B\u0011q\nG\u0007\u0002!*\u0011\u0011\u000bF\u0001\u0007yI|w\u000e\u001e \n\u0005MC\u0012A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!a\u0015\r\t\u000ba3\u0001\u0019\u0001\u001d\u0002\u000b%tG-\u001a=")
public class CelebornColumnarBatchCodeGenBuild {
    private final Logger logger = LoggerFactory.getLogger(CelebornColumnarBatchCodeGenBuild.class);

    private Logger logger() {
        return this.logger;
    }

    public CelebornBatchBuilder create(StructType schema, int batchSize) {
        CodegenContext ctx = GenerateUnsafeProjection$.MODULE$.newCodeGenContext();
        Tuple4<StringBuilder, StringBuilder, StringBuilder, StringBuilder> codes = this.genCode(schema, batchSize);
        String codeBody = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(1141).append("\n         |\n         |public java.lang.Object generate(Object[] references) {\n         |  return new SpecificCelebornColumnarBatchBuilder(references);\n         |}\n         |\n         |class SpecificCelebornColumnarBatchBuilder extends ").append(CelebornBatchBuilder.class.getName()).append(" {\n         |\n         |  private Object[] references;\n         |  int rowCnt = 0;\n         |  ").append(codes._1()).append("\n         |\n         |  public SpecificCelebornColumnarBatchBuilder(Object[] references) {\n         |    this.references = references;\n         |  }\n         |\n         |  public void newBuilders() throws Exception {\n         |    rowCnt = 0;\n         |    ").append(codes._2()).append("\n         |  }\n         |\n         |  public byte[] buildColumnBytes() throws Exception {\n         |    ").append(ByteArrayOutputStream.class.getName()).append(" giantBuffer = new ").append(ByteArrayOutputStream.class.getName()).append("();\n         |    byte[] rowCntBytes = int2ByteArray(rowCnt);\n         |    giantBuffer.write(rowCntBytes);\n         |    ").append(codes._3()).append("\n         |    return giantBuffer.toByteArray();\n         |  }\n         |\n         |  public void writeRow(InternalRow row) throws Exception {\n         |    ").append(codes._4()).append("\n         |    rowCnt += 1;\n         |  }\n         |\n         |  public int getRowCnt() {\n         |    return rowCnt;\n         |  }\n         |}\n       ").toString())).stripMargin();
        CodeAndComment code = CodeFormatter$.MODULE$.stripOverlappingComments(new CodeAndComment(codeBody, ctx.getPlaceHolderToComments()));
        this.logger().debug(new java.lang.StringBuilder(1).append("\n").append(CodeFormatter$.MODULE$.format(code, CodeFormatter$.MODULE$.format$default$2())).toString());
        Tuple2 tuple2 = CodeGenerator$.MODULE$.compile(code);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        GeneratedClass clazz = (GeneratedClass)tuple2._1();
        GeneratedClass clazz2 = clazz;
        return (CelebornBatchBuilder)clazz2.generate((Object[])ctx.references().toArray(ClassTag$.MODULE$.Any()));
    }

    public Tuple4<StringBuilder, StringBuilder, StringBuilder, StringBuilder> genCode(StructType schema, int batchSize) {
        StringBuilder initCode = new StringBuilder();
        StringBuilder buildCode = new StringBuilder();
        StringBuilder writeCode = new StringBuilder();
        StringBuilder writeRowCode = new StringBuilder();
        schema.indices().foreach((Function1 & Serializable & scala.Serializable)index -> CelebornColumnarBatchCodeGenBuild.$anonfun$genCode$1(this, schema, initCode, buildCode, batchSize, writeCode, writeRowCode, BoxesRunTime.unboxToInt((Object)index)));
        return new Tuple4((Object)initCode, (Object)buildCode, (Object)writeCode, (Object)writeRowCode);
    }

    public String genWriteCode(int index) {
        return new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(245).append("\n       |  ").append(ByteBuffer.class.getName()).append(" buffers").append(index).append(" = b").append(index).append(".build();\n       |  byte[] bytes").append(index).append(" = ").append(JavaUtils.class.getName()).append(".bufferToArray(buffers").append(index).append(");\n       |  byte[] columnBuilderBytes").append(index).append(" = int2ByteArray(bytes").append(index).append(".length);\n       |  giantBuffer.write(columnBuilderBytes").append(index).append(");\n       |  giantBuffer.write(bytes").append(index).append(");\n          ").toString())).stripMargin();
    }

    public static final /* synthetic */ StringBuilder $anonfun$genCode$1(CelebornColumnarBatchCodeGenBuild $this, StructType schema$1, StringBuilder initCode$1, StringBuilder buildCode$1, int batchSize$1, StringBuilder writeCode$1, StringBuilder writeRowCode$1, int index) {
        boolean bl = false;
        DecimalType decimalType = null;
        DataType dataType = schema$1.fields()[index].dataType();
        if (ByteType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornByteCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(CelebornByteCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornBooleanCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(87).append("\n               |  b").append(index).append("  = new ").append(CelebornBooleanCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornShortCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(CelebornShortCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornIntCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(CelebornIntCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (LongType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornLongCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(CelebornLongCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornFloatCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(CelebornFloatCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornDoubleCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(CelebornDoubleCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (StringType$.MODULE$.equals(dataType)) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornStringCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(86).append("\n               |  b").append(index).append(" = new ").append(CelebornStringCodeGenColumnBuilder.class.getName()).append("();\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (dataType instanceof DecimalType) {
            bl = true;
            decimalType = (DecimalType)dataType;
            if (decimalType.precision() <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornCompactMiniDecimalCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
                buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(131).append("\n               |  b").append(index).append(" =\n               |  new ").append(CelebornCompactMiniDecimalCodeGenColumnBuilder.class.getName()).append("(\n               |  new ").append(DecimalType.class.getName()).append("(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append("));\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
                writeCode$1.append($this.genWriteCode(index));
                return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
            }
        }
        if (bl && decimalType.precision() <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornCompactDecimalCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(131).append("\n               |  b").append(index).append(" =\n               |  new ").append(CelebornCompactDecimalCodeGenColumnBuilder.class.getName()).append("\n               |  (new ").append(DecimalType.class.getName()).append("(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append("));\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        if (bl) {
            initCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(33).append("\n               |  ").append(CelebornDecimalCodeGenColumnBuilder.class.getName()).append(" b").append(index).append(";\n          ").toString())).stripMargin());
            buildCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(113).append("\n               |  b").append(index).append(" = new ").append(CelebornDecimalCodeGenColumnBuilder.class.getName()).append("\n               |  (new ").append(DecimalType.class.getName()).append("(").append(decimalType.precision()).append(", ").append(decimalType.scale()).append("));\n               |  b").append(index).append(".initialize(").append(batchSize$1).append(", \"").append(schema$1.fields()[index].name()).append("\", false);\n          ").toString())).stripMargin());
            writeCode$1.append($this.genWriteCode(index));
            return writeRowCode$1.append(new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(50).append("\n               |  b").append(index).append(".appendFrom(row, ").append(index).append(");\n          ").toString())).stripMargin());
        }
        throw new MatchError((Object)dataType);
    }
}

