/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import java.io.IOException;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.spark.ShuffleDependency;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.Private;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.shuffle.ShuffleWriteMetricsReporter;
import org.apache.spark.shuffle.celeborn.CelebornShuffleHandle;
import org.apache.spark.shuffle.celeborn.CustomShuffleDependencyUtils;
import org.apache.spark.shuffle.celeborn.HashBasedShuffleWriter;
import org.apache.spark.shuffle.celeborn.SendBufferPool;
import org.apache.spark.shuffle.celeborn.SparkUtils;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.UnsafeRowSerializer;
import org.apache.spark.sql.execution.columnar.CelebornBatchBuilder;
import org.apache.spark.sql.execution.columnar.CelebornColumnarBatchBuilder;
import org.apache.spark.sql.execution.columnar.CelebornColumnarBatchCodeGenBuild;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Product2;
import scala.collection.Iterator;

@Private
public class ColumnarHashBasedShuffleWriter<K, V, C>
extends HashBasedShuffleWriter<K, V, C> {
    private static final Logger logger = LoggerFactory.getLogger(ColumnarHashBasedShuffleWriter.class);
    private final int stageId;
    private final int shuffleId;
    private final CelebornBatchBuilder[] celebornBatchBuilders;
    private final StructType schema;
    private final Serializer depSerializer;
    private final boolean isColumnarShuffle;
    private final int columnarShuffleBatchSize;
    private final boolean columnarShuffleCodeGenEnabled;
    private final boolean columnarShuffleDictionaryEnabled;
    private final double columnarShuffleDictionaryMaxFactor;

    public ColumnarHashBasedShuffleWriter(int shuffleId, CelebornShuffleHandle<K, V, C> handle, TaskContext taskContext, CelebornConf conf, ShuffleClient client, ShuffleWriteMetricsReporter metrics, SendBufferPool sendBufferPool) throws IOException {
        super(shuffleId, handle, taskContext, conf, client, metrics, sendBufferPool);
        this.columnarShuffleBatchSize = conf.columnarShuffleBatchSize();
        this.columnarShuffleCodeGenEnabled = conf.columnarShuffleCodeGenEnabled();
        this.columnarShuffleDictionaryEnabled = conf.columnarShuffleDictionaryEnabled();
        this.columnarShuffleDictionaryMaxFactor = conf.columnarShuffleDictionaryMaxFactor();
        ShuffleDependency shuffleDependency = handle.dependency();
        this.stageId = taskContext.stageId();
        this.shuffleId = shuffleDependency.shuffleId();
        this.schema = CustomShuffleDependencyUtils.getSchema(shuffleDependency);
        this.depSerializer = handle.dependency().serializer();
        this.celebornBatchBuilders = new CelebornBatchBuilder[handle.dependency().partitioner().numPartitions()];
        this.isColumnarShuffle = this.schema != null && CelebornBatchBuilder.supportsColumnarType(this.schema);
    }

    @Override
    protected void fastWrite0(Iterator iterator) throws IOException, InterruptedException {
        if (this.isColumnarShuffle) {
            logger.info("Fast columnar write of columnar shuffle {} for stage {}.", (Object)this.shuffleId, (Object)this.stageId);
            this.fastColumnarWrite0(iterator);
        } else {
            super.fastWrite0(iterator);
        }
    }

    private void fastColumnarWrite0(Iterator iterator) throws IOException {
        Iterator records = iterator;
        SQLMetric dataSize = SparkUtils.getDataSize((UnsafeRowSerializer)this.depSerializer);
        while (records.hasNext()) {
            Product2 record = (Product2)records.next();
            int partitionId = (Integer)record._1();
            UnsafeRow row = (UnsafeRow)record._2();
            if (this.celebornBatchBuilders[partitionId] == null) {
                CelebornBatchBuilder columnBuilders = this.columnarShuffleCodeGenEnabled && !this.columnarShuffleDictionaryEnabled ? new CelebornColumnarBatchCodeGenBuild().create(this.schema, this.columnarShuffleBatchSize) : new CelebornColumnarBatchBuilder(this.schema, this.columnarShuffleBatchSize, this.columnarShuffleDictionaryMaxFactor, this.columnarShuffleDictionaryEnabled);
                columnBuilders.newBuilders();
                this.celebornBatchBuilders[partitionId] = columnBuilders;
            }
            this.celebornBatchBuilders[partitionId].writeRow((InternalRow)row);
            if (this.celebornBatchBuilders[partitionId].getRowCnt() >= this.columnarShuffleBatchSize) {
                byte[] arr = this.celebornBatchBuilders[partitionId].buildColumnBytes();
                this.pushGiantRecord(partitionId, arr, arr.length);
                if (dataSize != null) {
                    dataSize.add((long)arr.length);
                }
                this.celebornBatchBuilders[partitionId].newBuilders();
            }
            this.incRecordsWritten(partitionId);
        }
    }

    @Override
    protected void closeWrite() throws IOException {
        if (this.canUseFastWrite() && this.isColumnarShuffle) {
            this.closeColumnarWrite();
        } else {
            super.closeWrite();
        }
    }

    private void closeColumnarWrite() throws IOException {
        SQLMetric dataSize = SparkUtils.getDataSize((UnsafeRowSerializer)this.depSerializer);
        for (int i = 0; i < this.celebornBatchBuilders.length; ++i) {
            CelebornBatchBuilder builders = this.celebornBatchBuilders[i];
            if (builders == null || builders.getRowCnt() <= 0) continue;
            byte[] buffers = builders.buildColumnBytes();
            if (dataSize != null) {
                dataSize.add((long)buffers.length);
            }
            this.mergeData(i, buffers, 0, buffers.length);
            this.celebornBatchBuilders[i] = null;
        }
    }

    @VisibleForTesting
    public boolean isColumnarShuffle() {
        return this.isColumnarShuffle;
    }
}

