/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.rpc.netty;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.rpc.RpcAddress;
import org.apache.celeborn.common.rpc.netty.Dispatcher;
import org.apache.celeborn.common.rpc.netty.NettyRpcEnv;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnected;
import org.apache.celeborn.common.rpc.netty.RemoteProcessConnectionError;
import org.apache.celeborn.common.rpc.netty.RemoteProcessDisconnected;
import org.apache.celeborn.common.rpc.netty.RequestMessage;
import org.apache.celeborn.common.rpc.netty.RequestMessage$;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\rb!B\u0001\u0003\u0001!q!a\u0004(fiRL(\u000b]2IC:$G.\u001a:\u000b\u0005\r!\u0011!\u00028fiRL(BA\u0003\u0007\u0003\r\u0011\bo\u0019\u0006\u0003\u000f!\taaY8n[>t'BA\u0005\u000b\u0003!\u0019W\r\\3c_Jt'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c2\u0001A\b\u0018!\t\u0001R#D\u0001\u0012\u0015\t\u00112#\u0001\u0004tKJ4XM\u001d\u0006\u0003)\u0019\tqA\\3uo>\u00148.\u0003\u0002\u0017#\t\u0011\")Y:f\u001b\u0016\u001c8/Y4f\u0011\u0006tG\r\\3s!\tA2$D\u0001\u001a\u0015\tQb!\u0001\u0005j]R,'O\\1m\u0013\ta\u0012DA\u0004M_\u001e<\u0017N\\4\t\u0011y\u0001!\u0011!Q\u0001\n\u0001\n!\u0002Z5ta\u0006$8\r[3s\u0007\u0001\u0001\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u0015\u0011K7\u000f]1uG\",'\u000f\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003!qW\r\u001e;z\u000b:4\bCA\u0011(\u0013\tA#AA\u0006OKR$\u0018P\u00159d\u000b:4\b\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"!\t\u0001\t\u000byI\u0003\u0019\u0001\u0011\t\u000b\u0015J\u0003\u0019\u0001\u0014\t\u000fA\u0002!\u0019!C\u0005c\u0005y!/Z7pi\u0016\fE\r\u001a:fgN,7/F\u00013!\u0011\u0019$\b\u0010\u001f\u000e\u0003QR!!\u000e\u001c\u0002\u0015\r|gnY;se\u0016tGO\u0003\u00028q\u0005!Q\u000f^5m\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001b\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0005\u0002>}5\tA!\u0003\u0002@\t\tQ!\u000b]2BI\u0012\u0014Xm]:\t\r\u0005\u0003\u0001\u0015!\u00033\u0003A\u0011X-\\8uK\u0006#GM]3tg\u0016\u001c\b\u0005C\u0003D\u0001\u0011\u0005C)A\u0004sK\u000e,\u0017N^3\u0015\u0007\u0015[%\u000b\u0005\u0002G\u00136\tqIC\u0001I\u0003\u0015\u00198-\u00197b\u0013\tQuI\u0001\u0003V]&$\b\"\u0002'C\u0001\u0004i\u0015AB2mS\u0016tG\u000f\u0005\u0002O!6\tqJ\u0003\u0002M'%\u0011\u0011k\u0014\u0002\u0010)J\fgn\u001d9peR\u001cE.[3oi\")1K\u0011a\u0001)\u0006q!/Z9vKN$X*Z:tC\u001e,\u0007CA+Y\u001b\u00051&BA,\u0014\u0003!\u0001(o\u001c;pG>d\u0017BA-W\u00059\u0011V-];fgRlUm]:bO\u0016DQa\u0011\u0001\u0005Bm#B!\u0012/^=\")AJ\u0017a\u0001\u001b\")1K\u0017a\u0001)\")qL\u0017a\u0001A\u0006A1-\u00197mE\u0006\u001c7\u000e\u0005\u0002OC&\u0011!m\u0014\u0002\u0014%B\u001c'+Z:q_:\u001cXmQ1mY\n\f7m\u001b\u0005\u0006I\u0002!I!Z\u0001\u0010S:$XM\u001d8bYJ+7-Z5wKR\u0019a\r[5\u0011\u0005\u0005:\u0017BA-\u0003\u0011\u0015a5\r1\u0001N\u0011\u0015Q7\r1\u0001l\u0003\u001diWm]:bO\u0016\u0004\"\u0001\\8\u000e\u00035T!A\u001c\u001d\u0002\u00079Lw.\u0003\u0002q[\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000bI\u0004A\u0011I:\u0002\u001f\rDWmY6SK\u001eL7\u000f^3sK\u0012$\u0012\u0001\u001e\t\u0003\rVL!A^$\u0003\u000f\t{w\u000e\\3b]\")\u0001\u0010\u0001C!s\u0006yQ\r_2faRLwN\\\"bk\u001eDG\u000f\u0006\u0003Fu\u0006E\u0001\"B>x\u0001\u0004a\u0018!B2bkN,\u0007cA?\u0002\f9\u0019a0a\u0002\u000f\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111A\u0010\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0015bAA\u0005\u000f\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0007\u0003\u001f\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005%q\tC\u0003Mo\u0002\u0007Q\nC\u0004\u0002\u0016\u0001!\t%a\u0006\u0002\u001b\rD\u0017M\u001c8fY\u0006\u001bG/\u001b<f)\r)\u0015\u0011\u0004\u0005\u0007\u0019\u0006M\u0001\u0019A'\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 \u0005y1\r[1o]\u0016d\u0017J\\1di&4X\rF\u0002F\u0003CAa\u0001TA\u000e\u0001\u0004i\u0005")
public class NettyRpcHandler
extends BaseMessageHandler
implements Logging {
    private final Dispatcher dispatcher;
    private final NettyRpcEnv nettyEnv;
    private final ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        NettyRpcHandler nettyRpcHandler = this;
        synchronized (nettyRpcHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    private ConcurrentHashMap<RpcAddress, RpcAddress> remoteAddresses() {
        return this.remoteAddresses;
    }

    @Override
    public void receive(TransportClient client, org.apache.celeborn.common.network.protocol.RequestMessage requestMessage) {
        try {
            ByteBuffer message = requestMessage.body().nioByteBuffer();
            RequestMessage messageToDispatch = this.internalReceive(client, message);
            this.dispatcher.postOneWayMessage(messageToDispatch);
        }
        catch (Exception exception) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error while invoking NettyRpcHandler#receive() for one-way message.";
                }
            }, exception);
        }
    }

    @Override
    public void receive(TransportClient client, org.apache.celeborn.common.network.protocol.RequestMessage requestMessage, RpcResponseCallback callback) {
        try {
            ByteBuffer message = requestMessage.body().nioByteBuffer();
            RequestMessage messageToDispatch = this.internalReceive(client, message);
            this.dispatcher.postRemoteMessage(messageToDispatch, callback);
        }
        catch (Exception exception) {
            RpcRequest rpcReq = (RpcRequest)requestMessage;
            this.logError((Function0<String>)new Serializable(this, rpcReq){
                public static final long serialVersionUID = 0L;
                private final RpcRequest rpcReq$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"Error while invoking NettyRpcHandler#receive() on RPC id ").append((Object)BoxesRunTime.boxToLong((long)this.rpcReq$1.requestId)).toString();
                }
                {
                    this.rpcReq$1 = rpcReq$1;
                }
            }, exception);
            callback.onFailure(exception);
        }
    }

    private RequestMessage internalReceive(TransportClient client, ByteBuffer message) {
        RequestMessage requestMessage;
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
        RequestMessage requestMessage2 = RequestMessage$.MODULE$.apply(this.nettyEnv, client, message);
        if (requestMessage2.senderAddress() == null) {
            requestMessage = new RequestMessage(clientAddr, requestMessage2.receiver(), requestMessage2.content());
        } else {
            RpcAddress remoteEnvAddress = requestMessage2.senderAddress();
            if (this.remoteAddresses().putIfAbsent(clientAddr, remoteEnvAddress) == null) {
                this.dispatcher.postToAll(new RemoteProcessConnected(remoteEnvAddress));
            }
            requestMessage = requestMessage2;
        }
        return requestMessage;
    }

    @Override
    public boolean checkRegistered() {
        return this.nettyEnv.checkRegistered();
    }

    @Override
    public void exceptionCaught(Throwable cause, TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr == null) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception before connecting to the client";
                }
            }, cause);
        } else {
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().get(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessConnectionError(cause, remoteEnvAddress));
            }
        }
    }

    @Override
    public void channelActive(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        Predef$.MODULE$.assert(addr != null);
        RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
        this.dispatcher.postToAll(new RemoteProcessConnected(clientAddr));
    }

    @Override
    public void channelInactive(TransportClient client) {
        InetSocketAddress addr = (InetSocketAddress)client.getChannel().remoteAddress();
        if (addr != null) {
            RpcAddress clientAddr = new RpcAddress(addr.getHostString(), addr.getPort());
            this.nettyEnv.removeOutbox(clientAddr);
            this.dispatcher.postToAll(new RemoteProcessDisconnected(clientAddr));
            RpcAddress remoteEnvAddress = this.remoteAddresses().remove(clientAddr);
            if (remoteEnvAddress != null) {
                this.dispatcher.postToAll(new RemoteProcessDisconnected(remoteEnvAddress));
            }
        }
    }

    public NettyRpcHandler(Dispatcher dispatcher, NettyRpcEnv nettyEnv) {
        this.dispatcher = dispatcher;
        this.nettyEnv = nettyEnv;
        Logging$class.$init$(this);
        this.remoteAddresses = JavaUtils.newConcurrentHashMap();
    }
}

