/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.cli.commands.table;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.stream.cli.commands.ClientCommand;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;

public class IncrementCommand
extends ClientCommand<Flags> {
    private static final String NAME = "inc";
    private static final String DESC = "Increment the amount of a key in a table";

    public IncrementCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new Flags()).withArgumentsUsage("<table> <key> <amount>").build());
    }

    @Override
    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    protected void run(StorageClient client, Flags flags) throws Exception {
        Preconditions.checkArgument((flags.arguments.size() >= 3 ? 1 : 0) != 0, (Object)"table and key/amount are not provided");
        String tableName = (String)flags.arguments.get(0);
        String key = (String)flags.arguments.get(1);
        long amount = Long.parseLong((String)flags.arguments.get(2));
        try (Table table = (Table)FutureUtils.result((CompletableFuture)client.openTable(tableName));){
            FutureUtils.result((CompletableFuture)table.increment((Object)Unpooled.wrappedBuffer((byte[])key.getBytes(StandardCharsets.UTF_8)), amount));
            this.spec.console().println("Successfully increment kv: ('" + key + "', amount = '" + amount + "').");
        }
    }

    public static class Flags
    extends CliFlags {
    }
}

