---
title:  "Beam community update!"
date:   2019-05-11 00:00:01 -0800
categories:
  - blog
aliases:
  - /blog/2019/05/11/beam-summit-europe-2019.html
authors:
  - mbaetens
---
<!--
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
-->

# The Apache Beam community in 2019


2019 has already been a busy time for the Apache Beam community. The ASF blog featured [our way of community building](https://blogs.apache.org/comdev/date/20190222) and we've had [more Beam meetups](https://www.meetup.com/San-Francisco-Apache-Beam/events/257482350)  around the world. Apache Beam also received the [Technology of the Year Award](https://www.infoworld.com/article/3336072/infoworlds-2019-technology-of-the-year-award-winners.html) from InfoWorld.

As these events happened, we were building up to the [20th anniversary of the Apache Software Foundation](https://opensource.googleblog.com/2019/03/celebrating-20-years-of-apache.html).  The contributions of the Beam community were a part of Maximilian Michels blog post on the success of the ASF's open source development model:

<blockquote class="twitter-tweet" data-lang="nl"><p lang="en" dir="ltr">Success at Apache: What You Need to Know by Maximilian Michels <a href="https://t.co/XjtVYgPAHX">https://t.co/XjtVYgPAHX</a> <a href="https://twitter.com/hashtag/Apache?src=hash&amp;ref_src=twsrc%5Etfw">#Apache</a> <a href="https://twitter.com/hashtag/Open?src=hash&amp;ref_src=twsrc%5Etfw">#Open</a> <a href="https://twitter.com/hashtag/Innovation?src=hash&amp;ref_src=twsrc%5Etfw">#Innovation</a> <a href="https://twitter.com/hashtag/Community?src=hash&amp;ref_src=twsrc%5Etfw">#Community</a> <a href="https://twitter.com/hashtag/people?src=hash&amp;ref_src=twsrc%5Etfw">#people</a> <a href="https://twitter.com/hashtag/processes?src=hash&amp;ref_src=twsrc%5Etfw">#processes</a> <a href="https://twitter.com/hashtag/JustWorks?src=hash&amp;ref_src=twsrc%5Etfw">#JustWorks</a> <a href="https://twitter.com/stadtlegende?ref_src=twsrc%5Etfw">@stadtlegende</a> <a href="https://t.co/xSibnyWAMe">pic.twitter.com/xSibnyWAMe</a></p>&mdash; Apache - The ASF (@TheASF) <a href="https://twitter.com/TheASF/status/1110364656143601664?ref_src=twsrc%5Etfw">26 maart 2019</a></blockquote>

<script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>

In that spirit, let's have an overview of the things that have happened, what the next few months look like, and how we can foster even more community growth.


## Meetups
We've had a flurry of activity, with several meetups in the planning process and more popping up globally over time. As diversity of contributors is a core ASF value, this geographic spread is exciting for the community. Here's a picture from the latest Apache Beam meetup organized at Lyft in San Francisco:

<img src="https://secure.meetupstatic.com/photos/event/8/0/1/2/600_481292786.jpeg" alt="Beam Meetup Bay Area" >

We have more [Bay Area meetups](https://www.meetup.com/San-Francisco-Apache-Beam) coming soon, and the community is looking into kicking off a meetup in Toronto!

[London](https://www.meetup.com/London-Apache-Beam-Meetup) had its first meetup of 2019 at the start of April:

<img src="https://secure.meetupstatic.com/photos/event/4/7/0/e/600_480318190.jpeg" alt="Beam Meetup London" height="360" width="640" >

and [Stockholm](https://www.meetup.com/Apache-Beam-Stockholm/events/260634514) had its second meetup at the start of May:

<blockquote class="twitter-tweet" data-lang="en-gb"><p lang="en" dir="ltr">Big audience for the second <a href="https://twitter.com/ApacheBeam?ref_src=twsrc%5Etfw">@ApacheBeam</a> meetup in Stockholm! Gleb, <a href="https://twitter.com/kanterov?ref_src=twsrc%5Etfw">@kanterov</a> from <a href="https://twitter.com/SpotifyEng?ref_src=twsrc%5Etfw">@SpotifyEng</a> kicking off the first talk with Beam SQL.<a href="https://twitter.com/hashtag/ApacheBeamStockholm?src=hash&amp;ref_src=twsrc%5Etfw">#ApacheBeamStockholm</a> <a href="https://t.co/fDqPPFh2gY">pic.twitter.com/fDqPPFh2gY</a></p>&mdash; Matthias Baetens 🌆 (@matthiasbaetens) <a href="https://twitter.com/matthiasbaetens/status/1125442916711915521?ref_src=twsrc%5Etfw">6 May 2019</a></blockquote>
<script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>

Keep an eye out for a meetup in [Paris](https://www.meetup.com/Paris-Apache-Beam-Meetup).

If you are interested in starting your own meetup, feel free [to reach out](https://beam.apache.org/community/contact-us)! Good places to start include our Slack channel, the dev and user mailing lists, or the Apache Beam Twitter.

Even if you can’t travel to these meetups, you can stay informed on the happenings of the community.  The talks and sessions from previous conferences and meetups are archived on the [Apache Beam YouTube channel](https://www.youtube.com/c/ApacheBeamYT). If you want your session added to the channel, don’t hesitate to get in touch! And in case you want to attend the next Beam event in style, you can also order your swag on the [Beam swag store](https://store-beam.myshopify.com)

## Summits
The first summit of the year will be held in Berlin:

<img src="https://img.evbuc.com/https%3A%2F%2Fcdn.evbuc.com%2Fimages%2F58635346%2F70962106775%2F1%2Foriginal.20190317-212619?w=800&auto=compress&rect=0%2C115%2C2666%2C1333&s=2680f5036dcad9177b027cce026c0224" alt="Beam Summit Europe Banner" >

You can find more info on the [website](https://beamsummit.org) and read about the inaugural edition of the Beam Summit Europe [here](https://beam.apache.org/blog/2018/10/31/beam-summit-aftermath.html). At these summits, you have the opportunity to meet with other Apache Beam creators and users, get expert advice, learn from the speaker sessions, and participate in workshops.

We strongly encourage you to get involved again this year! You can participate in the following ways for the upcoming summit in Europe:

🎫 If you want to secure your ticket to attend the Beam Summit Europe 2019, check our [event page](https://beam-summit-europe.eventbrite.com).

💸 If you want to make the Summit even **more** awesome, check out our [sponsor booklet](https://drive.google.com/file/d/1R3vvOHihQbpuzF2aaSV8WYg9YHRmJwxS/view)!

We also launched the CfP for our Beam Summit in North America, which will be held in collaboration with [ApacheCon](https://www.apachecon.com).

🎤 If you want to give a talk, take a look at our [CfP](https://www.apachecon.com/acna19/cfp.html).

Stay tuned for more information on the summit in North America and Asia.

## Why community engagement matters
Why we need a strong Apache Beam community:
* We're receiving lots of code contributions and need committers to review those and help onboard new contributors to the project.
* We want people to feel a sense of ownership to the project. By fostering this level of engagement, the work becomes even more exciting.
* A healthy community has a further reach and leads to more growth. More hours can be contributed to the project as we can spread the work and ownership.

Why are we organizing these summits:
* We'd like to give folks a place to meet, congregate, and share ideas.
* We know that offline interactions often changes the nature of the online ones in a positive manner.
* Building an active and diverse community is part of the Apache Way. These summits provide an opportunity for us to engage people from different locations, companies, and backgrounds.

<!--more-->
