/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avro.grpc;

import com.google.common.io.ByteStreams;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.avro.Protocol;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.grpc.AvroGrpcUtils;
import org.apache.avro.grpc.AvroInputStream;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;

public class AvroRequestMarshaller
implements MethodDescriptor.Marshaller<Object[]> {
    private static final EncoderFactory ENCODER_FACTORY = new EncoderFactory();
    private static final DecoderFactory DECODER_FACTORY = new DecoderFactory();
    private final Protocol.Message message;

    public AvroRequestMarshaller(Protocol.Message message) {
        this.message = message;
    }

    public InputStream stream(Object[] value) {
        return new AvroRequestInputStream(value, this.message);
    }

    public Object[] parse(InputStream stream) {
        try {
            BinaryDecoder in = DECODER_FACTORY.binaryDecoder(stream, null);
            Schema reqSchema = this.message.getRequest();
            GenericRecord request = (GenericRecord)new SpecificDatumReader(reqSchema).read(null, (Decoder)in);
            Object[] args = new Object[reqSchema.getFields().size()];
            int i = 0;
            for (Schema.Field field : reqSchema.getFields()) {
                args[i++] = request.get(field.name());
            }
            Object[] objectArray = args;
            return objectArray;
        }
        catch (IOException e) {
            throw Status.INTERNAL.withCause((Throwable)e).withDescription("Error deserializing avro request arguments").asRuntimeException();
        }
        finally {
            AvroGrpcUtils.skipAndCloseQuietly(stream);
        }
    }

    private static class AvroRequestInputStream
    extends AvroInputStream {
        private final Protocol.Message message;
        private Object[] args;

        AvroRequestInputStream(Object[] args, Protocol.Message message) {
            this.args = args;
            this.message = message;
        }

        public int drainTo(OutputStream target) throws IOException {
            int written;
            if (this.getPartial() != null) {
                written = (int)ByteStreams.copy((InputStream)this.getPartial(), (OutputStream)target);
            } else {
                Schema reqSchema = this.message.getRequest();
                AvroInputStream.CountingOutputStream outputStream = new AvroInputStream.CountingOutputStream(target);
                BinaryEncoder out = ENCODER_FACTORY.binaryEncoder((OutputStream)outputStream, null);
                int i = 0;
                for (Schema.Field param : reqSchema.getFields()) {
                    new SpecificDatumWriter(param.schema()).write(this.args[i++], (Encoder)out);
                }
                out.flush();
                this.args = null;
                written = outputStream.getWrittenCount();
            }
            return written;
        }
    }
}

